% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pooled_data.R
\name{get_pooled_data}
\alias{get_pooled_data}
\title{Generate pooled data for pharmacokinetic analysis}
\usage{
get_pooled_data(
  dat,
  dose_type = c("first_dose", "repeated_doses", "combined_doses"),
  pooled_ctrl = pooled_control()
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{dose_type}{Specifies the dosing context of the pharmacokinetic
observations. Classified as:
\itemize{
\item first_dose: data include only observations following the initial
administration
\item repeated_doses: data include only observations during repeated or
steady-state dosing
\item combined_doses: data include observations from both first-dose and
repeated-dose intervals
}}

\item{pooled_ctrl}{A list of control parameters created by
'pooled_control', including settings for binning and time rounding.}
}
\value{
A list containing pooled pharmacokinetic datasets depending on the specified
dose type:
\itemize{
\item datpooled_fd: pooled data for first-dose observations
\item datpooled_efd: pooled data for repeated dosing
\item datpooled_all: pooled data combining first-dose and repeated-dose
observations
}
}
\description{
Processes pharmacokinetic data and produces pooled datasets according to
the dosing context. Data can be grouped based on first dose, repeated dosing,
or a combination of both, with control over binning and time alignment.
}
\details{
For repeated-doses and combined-doses classifications, the most common
interdose interval is identified from dosing records and used to determine
whether observations fall within the relevant interval. If tad_rounding is
TRUE, both time after dose and dosing interval are rounded before comparison.
}
\examples{
dat <- processData(Bolus_1CPT)$dat
get_pooled_data(dat, dose_type = "combined_doses")

}
\seealso{
\link{pooled_control}, \link{trimmed_geom_mean}
}
\author{
Zhonghui Huang
}
