% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOmegas.R
\name{getOmegas}
\alias{getOmegas}
\title{Generate ETA variance and covariance table}
\usage{
getOmegas()
}
\value{
A \code{data.frame} with columns: \code{Parameters}, \code{Methods}, and \code{Values}.
}
\description{
This function constructs a combined table containing:
\itemize{
\item \strong{ETA variances} (e.g., \code{eta.cl}, \code{eta.vc}), which represent inter-individual variability (IIV) in pharmacokinetic parameters;
\item \strong{Derived covariances} (e.g., \code{cov.eta_cl_vc}) computed from ETA variances and assumed pairwise correlations.
}
}
\details{
ETA variances are initialized to 0.1 by default. Correlations within defined omega blocks
(block 1: \code{eta.vmax}, \code{eta.km}; block 2: \code{eta.cl}, \code{eta.vc}, \code{eta.vp}, \code{eta.vp2}, \code{eta.q}, \code{eta.q2})
are assumed to be 0.1 and used to compute covariances as:
\deqn{Cov(i, j) = sqrt(Var_i) * sqrt(Var_j) * Corr(i, j)}

The resulting output format aligns with \code{Recommended_initial_estimates}.
}
\examples{
getOmegas()
}
