% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initsControl.R
\name{fallback_control}
\alias{fallback_control}
\title{Control settings for fallback rules in parameter estimation}
\usage{
fallback_control(
  enable_ka_fallback = FALSE,
  sigma_method_additive = "model",
  sigma_method_proportional = "model",
  sigma_fallback_fraction = 0.2
)
}
\arguments{
\item{enable_ka_fallback}{Logical value indicating whether to apply a fallback
to ka = 1 if the estimated value is invalid.}

\item{sigma_method_additive}{Method for additive sigma. Options are
"model" or "fixed_fraction".}

\item{sigma_method_proportional}{Method for proportional sigma. Options are
"model" or "fixed_fraction".}

\item{sigma_fallback_fraction}{Numeric value specifying the fallback fraction,
for example, 0.2 corresponds to 20 percent of the mean of observed concentrations.}
}
\value{
A list of fallback control parameters.
}
\description{
Control settings for fallback rules in parameter estimation
}
\examples{
fallback_control()

}
