% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscAlgorithms.R
\name{expAv}
\alias{expAv}
\title{Matrix Exponential times a vector}
\usage{
expAv(A, v, tol = 1e-08, rescaleFreq = 10, Nmax = 10000, sparse = TRUE)
}
\arguments{
\item{A}{Square matrix.}

\item{v}{vector to multiply by the matrix exponential \code{exp(A) \%*\% v}.}

\item{tol}{level of accuracy required (default = 1e-8).}

\item{rescaleFreq}{How frequently should the terms be scaled to avoid underflow/overflow (default = 10).}

\item{Nmax}{Maximum number of iterations to compute (default = 10000).}

\item{sparse}{(logical) specify if the matrix may be sparse and to do sparse computation (default = TRUE).}
}
\value{
the result as a vector.
}
\description{
Compute the combined term \code{expm(A) \%*\% v} to avoid a full matrix exponentiation.
}
\details{
For large matrix exponentials it is much more efficient to compute \code{exp(A) \%*\% v}, than to actually compute the entire matrix exponential.

This function follows the function \code{expAv} from the R package \pkg{RTMB} (Kristensen, 2025), and theory outlined in Sherlock (2021). It is developed for working with continuous times
Markov chains. If using the matrix exponential to create a transition probability matrix in a HMM context just once, 
this function may be slower than the one time call to compute the full matrix exponentiation. If a full matrix exponentiation is required, refer to 
\code{expm} to compute. Choosing \code{sparse = TRUE} will check which values of \code{A} are non-zero and do sparse linear algebra.
Note that for computation efficiency matrix uniformization is done by \code{A* = A + rho I}, where \code{rho = max(abs(diag(A)))}; see Algorithm 2' in Sherlock (2021).
When the row sums of the matrix are not zero, then uniformization is not done, and the number of iterations to reach tolerance are approximated based on the
a bound of the spectrum, similar to \pkg{RTMB} (Kristensen, 2025).
}
\examples{
A <- rbind(c(-1, 0.25, 0.75), c(0, -2, 2), c(0.25, 0.25, -0.5))
v <- c(0.35, 0.25, 0.1)
expAv(A, v)
}
\references{
Sherlock, C. (2021). Direct statistical inference for finite Markov jump processes via the matrix exponential. Computational Statistics, 36(4), 2863-2887.

Kristensen K (2025). _RTMB: 'R' Bindings for 'TMB'_. R package version 1.7, commit 6bd7a16403ccb4d3fc13ff7526827540bf27b352, 
<https://github.com/kaskr/RTMB>.
}
\author{
Paul van Dam-Bates
}
