% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{bipartite_from_data_frame}
\alias{bipartite_from_data_frame}
\title{two-mode network from a data.frame}
\usage{
bipartite_from_data_frame(d, type1, type2, attr = NULL, weighted = TRUE)
}
\arguments{
\item{d}{data.frame}

\item{type1}{column name of mode 1}

\item{type2}{column name of mode 2}

\item{attr}{named list of edge attributes}

\item{weighted}{should a weighted graph be created if multiple edges occur}
}
\value{
two mode network as igraph object
}
\description{
Create a two-mode network from a data.frame
}
\examples{
library(igraph)
edges <- data.frame(mode1 = 1:5, mode2 = letters[1:5])
bipartite_from_data_frame(edges, "mode1", "mode2")
}
\author{
David Schoch
}
