\name{netClust-package}
\alias{netClust-package}
\alias{netClust}
\docType{package}
\title{
\packageTitle{netClust}
}
\description{
\packageDescription{netClust}
}
\details{

The DESCRIPTION file:
\packageDESCRIPTION{netClust}
\packageIndices{netClust}
Provides model-based clustering for weighted networks. Core functions: netEM_unilayer() and netEM_multilayer().
}
\author{
\packageAuthor{netClust}

Maintainer: \packageMaintainer{netClust}
}
\references{
Melnykov, V., Sarkar, S. and Melnykov, Y., 2021. On finite mixture modeling and model-based clustering of directed weighted multilayer networks. Pattern Recognition, 112, p.107641.
}

\keyword{ package }

\examples{
data(netData) ## Read network data 
data(netDataID) ## Read original ID for network data

n <- dim(netData)[1] ## number of nodes of the network
p <- dim(netData)[4] ## number of layers of the network
K <- 2               ## number of clusters 
y <- netData

eps=0.0001
RndStrtUni= 5
RndStrtMult= 10
SmEMUni= 3
SmEMMult= 5
ItrSmEM=5
burn = 10*n
ItrMCMC= 100*n
sSigma = 1
sPsi = 1
a=0

\donttest{

#########################################################
### Run unilayer network EM seperately for each layer ###
#########################################################

for (MatC in 1:p){
  
  x <- array(0, dim = c(n,n,2))
  for (i in 1:n){
    for (j in 1:n){
      x[i,j,] <- y[i,j,,MatC]
    }
  }
  
  E <- netEM_unilayer(x, K, eps, RndStrtUni, SmEMUni, ItrSmEM, burn, ItrMCMC, sSigma,a)
  cat("Unilayer network", "Original ID", netDataID, "\n")
  cat("Unilayer network", "Feature", MatC, "Assigned ID", E$id, "\n")
  
}

##################################
### Run multilayer network EM  ###
##################################

E <- netEM_multilayer(y,K,p, eps, RndStrtMult, SmEMMult, ItrSmEM, burn, ItrMCMC, sSigma, sPsi, n, a)
cat("Multilayer network", "Original ID", netDataID, "\n")
cat("Multilayer network", "Assigned ID", E$id, "\n")

}
}
