% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_bulk.R
\name{as_data_frame}
\alias{as_data_frame}
\title{Convert BulkPhyloExpressionSet to Data Frame}
\usage{
as_data_frame(phyex_set, use_collapsed = FALSE)
}
\arguments{
\item{phyex_set}{A BulkPhyloExpressionSet object}

\item{use_collapsed}{Logical indicating whether to use collapsed expression data (default: FALSE)}
}
\value{
A data frame where column 1 contains phylostratum information, 
column 2 contains gene IDs, and columns 3+ contain expression data
}
\description{
Convert a BulkPhyloExpressionSet object back to the original data frame format
with phylostratum, gene ID, and expression data as columns.
}
\examples{
# Convert BulkPhyloExpressionSet back to data frame
df <- as_data_frame(example_phyex_set)
df_collapsed <- as_data_frame(example_phyex_set, use_collapsed = TRUE)

}
