% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_scale.R
\name{simplify_scale}
\alias{simplify_scale}
\alias{best_simplification}
\title{Best ways to regularize a scale}
\usage{
simplify_scale(
  set,
  start_zero = TRUE,
  ineqmat = NULL,
  scales = NULL,
  signvector_list = NULL,
  adjlist = NULL,
  method = c("euclidean", "taxicab", "chebyshev", "hamming"),
  display_digits = 2,
  edo = 12,
  rounder = 10
)

best_simplification(set, ...)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{start_zero}{Boolean: should the result be transposed so that its pitch
initial is zero? Defaults to \code{TRUE}.}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to strings "white," "black", "gray", "roth", "infrared",
"pastel", "rosy", "infrared", or "anaglyph", giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}},
\code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, or \code{\link[=make_anaglyph_ineqmat]{make_anaglyph_ineqmat()}}. For other
arrangements, this parameter accepts explicit matrices.}

\item{scales}{List of scales representing the faces of your hyperplane
arrangement. Defaults to \code{NULL} in which case the function looks for
\code{representative_scales} in the global environment.}

\item{signvector_list}{A list of signvectors to use as the reference by
which \code{colornum} assigns a value. Defaults to \code{NULL} and will attempt to
use \code{representative_signvectors}, which needs to be downloaded and assigned
separately from the package musicMCT. (If a named \code{ineqmat} other than "mct"
is chosen, the function attempts to replace a \code{NULL} signvector list with
a corresponding object in the global environment. For instance, if \code{ineqmat="pastel"}
then the function tries to use \code{pastel_signvectors} for \code{signvector_list}.)}

\item{adjlist}{Adjacency list structured in the same way as \code{color_adjacencies}.
Defaults to \code{NULL} in which case the function looks for \code{color_adjacencies}
in the global environment.}

\item{method}{What distance metric should be used? Defaults to \code{"euclidean"}
(unlike most functions with a method parameter in musicMCT)
but can be \code{"taxicab"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{display_digits}{Integer: how many digits to display when naming any
non-integral interval sizes. Defaults to 2.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}

\item{...}{Other arguments to be passed from \code{best_simplification()}
to \code{simplify_scale()}.}
}
\value{
A matrix with \code{n+6} rows, where \code{n} is the number of notes in the
scale. Each column represents a scale which is a potential simplification
of the input \code{set}, together with details about that simplified scale.
The first \code{n} entries of the column represent the pitches of the scale
itself:
\itemize{
\item The \code{n+1}th row indicates the color number of the simplification.
\item The \code{n+2}th row shows how many degrees of freedom the simplification has
(always between \code{0} and \code{d-1} where \code{d} is \code{set}'s degree of freedom).
\item The \code{n+3}th row calculates the voice-leading distance from \code{set} to the
simplified scale (according to the chosen \code{method}, for which Euclidean
distance is the default because it corresponds to the assumption that
orthogonal projection finds the closest point on a neighboring flat).
\item The \code{n+4}th row counts how many more hyperplanes the simplified scale
lies on compared to \code{set}.
\item The \code{n+5}th row is a quotient of the previous
two rows (distance divided by number of new regularities).
\item The \code{n+6}th row calculates a final "score" which is used to order the
columns from best (first) to worst (last) simplifications. This score
is the inverse of the previous row divided by the total number of
hyperplanes in the arrangement. (Without this normalization, scores
for higher cardinalities quickly become much larger than scores for
low cardinalities.)
}

If \code{display_digits} is a value other than \code{NULL}, the function prints
to console a suitably rounded representation of the data, while
invisibly returning the unrounded information.

\code{best_simplification()} returns simply a numeric vector with the scale
judged optimal by \code{simplify_scale()} (i.e. the first \code{n} entries of
its first column, without all the other information).
}
\description{
Given an input scale, identify which adjacent colors represent good
approximations of it, in a sense consistent with "Modal Color Theory,"
pp. 31-32.
}
\details{
Suppose that you've gathered data on how a particular instrument is tuned.
Two intervals in its scale differ by about 12 cents: does it make sense
to consider those intervals to be essentially the same, up to some
combination of measurement error and the permissiveness of cognitive
categories? \code{simplify_scale()} helps to answer such a question by considering
whether eliding a precisely measured difference results in a significant
simplification of the overall scale structure.

It accomplishes this by starting from two premises:
\itemize{
\item Any simplification should move to an adjacent color with fewer
degrees of freedom.
\item There's a tradeoff between moving farther (i.e. requiring more
measurement fuzziness) and achieving greater regularity.
Therefore it starts by projecting the input scale onto all neighboring
flats with fewer degrees of freedom. Some projections can be rejected
immediately because the closest point on the flat isn't actually an
adjacent color. The non-rejected projections can therefore be ranked by
calculating the "cost" of each additional regularity: for every \code{1} or \code{-1}
in the sign vector that is converted to a \code{0}, how far does one have to
move in voice leading space?
}

To answer this question, \code{simplify_signvector} needs access to data about
the hyperplane arrangement in question. For the basic "Modal Color Theory"
arrangements, this is the data in \code{representative_scales.rds},
\code{representative_signvectors.rds}, and \code{color_adjacencies.rds}. The function
assumes that, if you don't specify other data, you have those three files
loaded into your workspace. It can't function without them.
}
\examples{
\dontshow{if (exists("representative_scales") && exists("representative_signvectors") && exists("color_adjacencies")) withAutoprint(\{ # examplesIf}
# For this example to run, you need the necessary data files loaded.
# Let's see what happens if we try to simplify the 5-limit just diatonic:

simplify_scale(j(dia))

# So the best option is color number 942659, which is the "well-formed"
# structure of the familiar diatonic scale. The particular saturation of
# that meantone structure is very close to 1/5-comma meantone:

simplified_jdia <- best_simplification(j(dia))
fifth_comma_dia <- sim(sort((meantone_fifth(1/5)*(0:6))\%\%12))[,5]
vl_dist(simplified_jdia, fifth_comma_dia)
\dontshow{\}) # examplesIf}
}
