% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anaglyph.R
\name{make_anaglyph_ineqmat}
\alias{make_anaglyph_ineqmat}
\title{Define hyperplanes for cross-type voice leadings}
\usage{
make_anaglyph_ineqmat(card)
}
\arguments{
\item{card}{Integer: the cardinality of the two sets to be compared.}
}
\value{
A matrix with \code{2*card+1} columns and k rows, where
k is  either 4 times an entry of \href{https://oeis.org/A050509}{A050509}
in the OEIS if \code{card} is even, or an entry of \href{https://oeis.org/A033594}{A033594}
if \code{card} is odd.
}
\description{
Voice leadings between members of a single set class are
well characterized by the Modal Color Theory arrangements
of \code{\link[=makeineqmat]{makeineqmat()}}. Those arrangements do not tell the whole
story for relationships between inequivalent sets. (For instance,
under what circumstances are two \code{\link[=brightnessgraph]{brightnessgraph()}} structures
equivalent when \code{set} and \code{goal} belong to different set classes?)
Such relationships are described by the "anaglyph" arrangements
produced by this function. (The name for the arrangements alludes
to those 20th-century 3D movie glasses which produce a stereoscopic
effect by using lenses of different colors for each eye. Like those
glasses, the anaglyph arrangements "see" two scalar colors at once.)
}
\details{
Note that, unlike for most other hyperplane arrangements, for
anaglyph arrangements \code{card} is only half the size of the data you're
working with, since anaglyph arrangements compare \emph{two} sets of size
\code{card}. In general, when useing anaglyph ineqmats with other functions,
such as \code{\link[=signvector]{signvector()}} or \code{\link[=howfree]{howfree()}}, you should enter the two sets
to be compared as a single vector, i.e. \code{c(set, goal)}. See the use of
\code{\link[=howfree]{howfree()}} in the example.
}
\examples{
min7 <- c(0, 3, 7, 10)
maj7 <- c(0, 4, 7, 11)
just_min7 <- j(1, m3, 5, m7)
just_maj7 <- j(1, 3, 5, 7)

# The 12tet and just pairs have the same anaglyph signvector:
anaglyph_tetrachords <- make_anaglyph_ineqmat(4)
signvector(c(min7, maj7), ineqmat=anaglyph_tetrachords)
signvector(c(just_min7, just_maj7), ineqmat=anaglyph_tetrachords)

# They therefore have equivalent brightness graphs:
brightnessgraph(min7, maj7)
brightnessgraph(just_min7, just_maj7)

# The pair is able to vary along two dimensions in anaglyph space:
howfree(c(min7, maj7), ineqmat="anaglyph")

}
