% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_2_rcv_d.R
\name{rcv_d}
\alias{rcv_d}
\title{Step 2: Generating fake data for parameter and model recovery}
\usage{
rcv_d(
  estimate,
  data,
  colnames,
  behrule,
  id = NULL,
  models,
  funcs = NULL,
  priors = NULL,
  settings = NULL,
  algorithm,
  lowers,
  uppers,
  control,
  ...
)
}
\arguments{
\item{estimate}{Estimate method that you want to use, 
see \link[multiRL]{estimate}}

\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{id}{The ID of the subject whose experimental structure (e.g., trial order) will 
be used as the template for generating all simulated data. 
Defaults to the first subject found in the input data.}

\item{models}{Reinforcement Learning Models}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{algorithm}{Algorithm packages that multiRL supports, 
see \link[multiRL]{algorithm}}

\item{lowers}{Lower bound of free parameters in each model.}

\item{uppers}{Upper bound of free parameters in each model.}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An S3 object of class \code{multiRL.recovery}.

  \describe{
    \item{\code{simulate}}{
      A \code{List} containing, for each model, the parameters used to 
      simulate the data.
    }
    \item{\code{recovery}}{
      A \code{List} containing, for each model,  the parameters estimated 
      as optimal by the algorithm.
    }
  }
}
\description{
Step 2: Generating fake data for parameter and model recovery
}
\section{Example}{
 
\preformatted{ # recovery
 recovery.MLE <- multiRL::rcv_d(
   estimate = "MLE",
   
   data = multiRL::TAB,
   colnames = list(
     object = c("L_choice", "R_choice"), 
     reward = c("L_reward", "R_reward"),
     action = "Sub_Choose"
   ),
   behrule = list(
     cue = c("A", "B", "C", "D"),
     rsp = c("A", "B", "C", "D")
   ),
   id = 1,

   models = list(multiRL::TD, multiRL::RSTD, multiRL::Utility),
   priors = list(
     list(
       alpha = function(x) {stats::rbeta(n = 1, shape1 = 2, shape2 = 2)}, 
       beta = function(x) {stats::rexp(n = 1, rate = 1)}
     ),
     list(
       alphaN = function(x) {stats::rbeta(n = 1, shape1 = 2, shape2 = 2)}, 
       alphaP = function(x) {stats::rbeta(n = 1, shape1 = 2, shape2 = 2)}, 
       beta = function(x) {stats::rexp(n = 1, rate = 1)}
     ),
     list(
       alpha = function(x) {stats::rbeta(n = 1, shape1 = 2, shape2 = 2)}, 
       beta = function(x) {stats::rexp(n = 1, rate = 1)},
       gamma = function(x) {stats::rbeta(n = 1, shape1 = 2, shape2 = 2)}
     )
   ),
   settings = list(name = c("TD", "RSTD", "Utility")),

   algorithm = "NLOPT_GN_MLSL",
   lowers = list(c(0, 0), c(0, 0, 0), c(0, 0, 0)),
   uppers = list(c(1, 5), c(1, 1, 5), c(1, 5, 1)),
   control = list(core = 10, sample = 100, iter = 100)
 )
}
}

