% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone_helpers.R
\name{with_localtime}
\alias{with_localtime}
\title{Convert timestamps to UTC while respecting local timezones}
\usage{
with_localtime(x, tz)
}
\arguments{
\item{x}{A vector of timestamps, either as \code{\link[lubridate:posix_utils]{lubridate::POSIXct}} or character strings.}

\item{tz}{A character vector of timezones corresponding to each element in \code{x}. If all elements
share the same timezone, a single value can be supplied.}
}
\value{
A \code{\link[lubridate:posix_utils]{lubridate::POSIXct}} vector in UTC.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This functions takes a vector of timestamps and a corresponding vector of time zones and converts
it to "localtime" at UTC. If you have a vector of timestamps with varying time zones, you cannot
represent them in a single vector with their own time zone. To this end, this function converts
each timestamp to its local time, and then force UTC as a time zone for all values.
}
\examples{
# Single timezone
x <- as.POSIXct("2025-05-10 12:00:00", tz = "UTC")
with_localtime(x, "Europe/Brussels")

# Multiple timezones
times <- as.POSIXct(c("2025-05-10 12:00:00", "2025-05-10 12:00:00"), tz = "UTC")
tzs <- c("Europe/Brussels", "America/New_York")

# Times not appear to be in UTC, but the values are in their local time zone.
with_localtime(times, tzs)
}
