% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R, R/format.R, R/print.R
\name{display.estimate_contrasts}
\alias{display.estimate_contrasts}
\alias{format.estimate_contrasts}
\alias{print.estimate_contrasts}
\title{Printing modelbased-objects}
\usage{
\method{display}{estimate_contrasts}(
  object,
  select = NULL,
  include_grid = NULL,
  full_labels = NULL,
  format = "markdown",
  ...
)

\method{format}{estimate_contrasts}(
  x,
  format = NULL,
  select = getOption("modelbased_select", NULL),
  include_grid = getOption("modelbased_include_grid", FALSE),
  ...
)

\method{print}{estimate_contrasts}(x, select = NULL, include_grid = NULL, full_labels = NULL, ...)
}
\arguments{
\item{select}{Determines which columns are printed and the table layout.
There are two options for this argument:
\itemize{
\item \strong{A string expression with layout pattern}

\code{select} is a string with "tokens" enclosed in braces. These tokens will be
replaced by their associated columns, where the selected columns will be
collapsed into one column. Following tokens are replaced by the related
coefficients or statistics: \code{{estimate}}, \code{{se}}, \code{{ci}} (or \code{{ci_low}} and
\code{{ci_high}}), \code{{p}}, \code{{pd}} and \code{{stars}}. The token \code{{ci}} will be replaced
by \verb{{ci_low}, {ci_high}}. Example: \code{select = "{estimate}{stars} ({ci})"}

It is possible to create multiple columns as well. A \code{|} separates values
into new cells/columns. Example: \code{select = "{estimate} ({ci})|{p}"}.
\item \strong{A string indicating a pre-defined layout}

\code{select} can be one of the following string values, to create one of the
following pre-defined column layouts:
\itemize{
\item \code{"minimal"}: Estimates, confidence intervals and numeric p-values, in two
columns. This is equivalent to \code{select = "{estimate} ({ci})|{p}"}.
\item \code{"short"}: Estimate, standard errors and numeric p-values, in two columns.
This is equivalent to \code{select = "{estimate} ({se})|{p}"}.
\item \code{"ci"}: Estimates and confidence intervals, no asterisks for p-values.
This is equivalent to \code{select = "{estimate} ({ci})"}.
\item \code{"se"}: Estimates and standard errors, no asterisks for p-values. This is
equivalent to \code{select = "{estimate} ({se})"}.
\item \code{"ci_p"}: Estimates, confidence intervals and asterisks for p-values. This
is equivalent to \code{select = "{estimate}{stars} ({ci})"}.
\item \code{"se_p"}: Estimates, standard errors and asterisks for p-values. This is
equivalent to \code{select = "{estimate}{stars} ({se})"}..
}
}

Using \code{select} to define columns will re-order columns and remove all columns
related to uncertainty (standard errors, confidence intervals), test statistics,
and p-values (and similar, like \code{pd} or \code{BF} for Bayesian models), because
these are assumed to be included or intentionally excluded when using \code{select}.
The new column order will be: Parameter columns first, followed by the "glue"
columns, followed by all remaining columns. If further columns should also be
placed first, add those as \code{focal_terms} attributes to \code{x}. I.e., following
columns are considers as "parameter columns" and placed first:
\code{c(easystats_columns("parameter"), attributes(x)$focal_terms)}.

\strong{Note:} glue-like syntax is still experimental in the case of more complex models
(like mixed models) and may not return expected results.}

\item{include_grid}{Logical, if \code{TRUE}, the data grid is included in the
table output. Only applies to prediction-functions like \code{estimate_relation()}
or \code{estimate_link()}. Default is \code{NULL}, which will set the value based on
\code{options(modelbased_include_grid)}, and use \code{FALSE} is no option is set.}

\item{full_labels}{Logical, if \code{TRUE} (default), all labels for focal terms
are shown. If \code{FALSE}, redundant (duplicated) labels are removed from rows.
Default is \code{NULL}, which will set the value based on
\code{options(modelbased_full_labels)}, and use \code{TRUE} is no option is set.}

\item{format}{String, indicating the output format. Can be \code{"markdown"}
\code{"html"}, or \code{"tt"}. \code{format = "html"} create a HTML table using the \emph{gt}
package. \code{format = "tt"} creates a \code{tinytable} object, which is either
printed as markdown or HTML table, depending on the environment. See
\code{\link[insight:export_table]{insight::export_table()}} for details.}

\item{...}{Arguments passed to \code{insight::format_table()} or
\code{insight::export_table()}.}

\item{x, object}{An object returned by the different \verb{estimate_*()} functions.}
}
\value{
Invisibly returns \code{x}.
}
\description{
\code{print()} method for \strong{modelbased} objects. Can be used to tweak the output
of tables.
}
\note{
Use \code{print_html()} and \code{print_md()} to create tables in HTML or
markdown format, respectively.
}
\section{Global Options to Customize Tables when Printing}{

Columns and table layout can be customized using \code{options()}:
\itemize{
\item \code{modelbased_select}: \verb{options(modelbased_select = <string>)} will set a
default value for the \code{select} argument and can be used to define a custom
default layout for printing.
\item \code{modelbased_include_grid}: \code{options(modelbased_include_grid = TRUE)} will
set a default value for the \code{include_grid} argument and can be used to
include data grids in the output by default or not.
\item \code{modelbased_full_labels}: \code{options(modelbased_full_labels = FALSE)} will
remove redundant (duplicated) labels from rows.
\item \code{easystats_display_format}: \verb{options(easystats_display_format = <value>)}
will set the default format for the \code{display()} methods. Can be one of
\code{"markdown"}, \code{"html"}, or \code{"tt"}.
}
}

\examples{
\dontshow{if (insight::check_if_installed("marginaleffects", quietly = TRUE)) withAutoprint(\{ # examplesIf}
model <- lm(Petal.Length ~ Species, data = iris)
out <- estimate_means(model, "Species")

# default
print(out)

# smaller set of columns
print(out, select = "minimal")

# remove redundant labels
data(efc, package = "modelbased")
efc <- datawizard::to_factor(efc, c("c161sex", "c172code", "e16sex"))
levels(efc$c172code) <- c("low", "mid", "high")
fit <- lm(neg_c_7 ~ c161sex * c172code * e16sex, data = efc)
out <- estimate_means(fit, c("c161sex", "c172code", "e16sex"))
print(out, full_labels = FALSE, select = "{estimate} ({se})")
\dontshow{\}) # examplesIf}
}
