% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{pool_predictions}
\alias{pool_predictions}
\alias{pool_slopes}
\title{Pool Predictions and Estimated Marginal Means}
\usage{
pool_predictions(x, transform = NULL, ...)

pool_slopes(x, transform = NULL, ...)
}
\arguments{
\item{x}{A list of \code{estimate_means} objects, as returned by
\code{\link[=estimate_means]{estimate_means()}}, or \code{estimate_predicted} objects, as returned by
\code{\link[=estimate_relation]{estimate_relation()}} and related functions. For \code{pool_slopes()}, must be
a list of \code{estimate_slopes} objects, as returned by \code{\link[=estimate_slopes]{estimate_slopes()}}.}

\item{transform}{A function applied to predictions and confidence intervals
to (back-) transform results, which can be useful in case the regression
model has a transformed response variable (e.g., \code{lm(log(y) ~ x)}). For
Bayesian models, this function is applied to individual draws from the
posterior distribution, before computing summaries. Can also be \code{TRUE}, in
which case \code{insight::get_transformation()} is called to determine the
appropriate transformation-function. Note that no standard errors are returned
when transformations are applied.}

\item{...}{Currently not used.}
}
\value{
A data frame with pooled predictions.
}
\description{
This function "pools" (i.e. combines) multiple \code{estimate_means} objects, in
a similar fashion as \code{\link[mice:pool]{mice::pool()}}.
}
\details{
Averaging of parameters follows Rubin's rules (\emph{Rubin, 1987, p. 76}).
Pooling is applied to the predicted values and based on the standard errors
as they are calculated in the \code{estimate_means} or \code{estimate_predicted}
objects provided in \code{x}. For objects of class \code{estimate_means}, the predicted
values are on the response scale by default, and standard errors are
calculated using the delta method. Then, pooling estimates and calculating
standard errors for the pooled estimates based ob Rubin's rule is carried
out. There is no back-transformation to the link-scale of predicted values
before applying Rubin's rule.
}
\examples{
\dontshow{if (require("mice") && requireNamespace("marginaleffects")) withAutoprint(\{ # examplesIf}
# example for multiple imputed datasets
data("nhanes2", package = "mice")
imp <- mice::mice(nhanes2, printFlag = FALSE)

# estimated marginal means
predictions <- lapply(1:5, function(i) {
  m <- lm(bmi ~ age + hyp + chl, data = mice::complete(imp, action = i))
  estimate_means(m, "age")
})
pool_predictions(predictions)

# estimated slopes (marginal effects)
slopes <- lapply(1:5, function(i) {
  m <- lm(bmi ~ age + hyp + chl, data = mice::complete(imp, action = i))
  estimate_slopes(m, "chl")
})
pool_slopes(slopes)
\dontshow{\}) # examplesIf}
}
\references{
Rubin, D.B. (1987). Multiple Imputation for Nonresponse in Surveys. New York:
John Wiley and Sons.
}
