% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_surv_rpart_cox.R
\name{LearnerSurvRpartCox}
\alias{LearnerSurvRpartCox}
\title{LearnerSurvRpartCox R6 class}
\description{
This learner is a wrapper around \code{\link[rpart:rpart]{rpart::rpart()}} in order to fit recursive
partitioning and regression trees with survival data.
}
\details{
Optimization metric: C-index
*
Can be used with
\itemize{
\item \link[mlexperiments:MLTuneParameters]{mlexperiments::MLTuneParameters}
\item \link[mlexperiments:MLCrossValidation]{mlexperiments::MLCrossValidation}
\item \link[mlexperiments:MLNestedCV]{mlexperiments::MLNestedCV}
}

Implemented methods:
\itemize{
\item \verb{$fit} To fit the model.
\item \verb{$predict} To predict new data with the model.
\item \verb{$cross_validation} To perform a grid search (hyperparameter
optimization).
\item \verb{$bayesian_scoring_function} To perform a Bayesian hyperparameter
optimization.
}

Parameters that are specified with \code{parameter_grid} and / or \code{learner_args}
are forwarded to \code{rpart}'s argument \code{control} (see
\code{\link[rpart:rpart.control]{rpart::rpart.control()}} for further details).
}
\examples{
# survival analysis
if (requireNamespace("survival", quietly = TRUE) &&
requireNamespace("glmnet", quietly = TRUE) &&
requireNamespace("rpart", quietly = TRUE) &&
requireNamespace("splitTools", quietly = TRUE)) {

  dataset <- survival::colon |>
    data.table::as.data.table() |>
    na.omit()
  dataset <- dataset[get("etype") == 2, ]

  seed <- 123
  surv_cols <- c("status", "time", "rx")

  feature_cols <- colnames(dataset)[3:(ncol(dataset) - 1)]

  ncores <- 2L

  split_vector <- splitTools::multi_strata(
    df = dataset[, .SD, .SDcols = surv_cols],
    strategy = "kmeans",
    k = 4
  )

  train_x <- model.matrix(
    ~ -1 + .,
    dataset[, .SD, .SDcols = setdiff(feature_cols, surv_cols[1:2])]
  )
  train_y <- survival::Surv(
    event = (dataset[, get("status")] |>
               as.character() |>
               as.integer()),
    time = dataset[, get("time")],
    type = "right"
  )

  fold_list <- splitTools::create_folds(
    y = split_vector,
    k = 3,
    type = "stratified",
    seed = seed
  )

  surv_rpart_optimizer <- mlexperiments::MLCrossValidation$new(
    learner = LearnerSurvRpartCox$new(),
    fold_list = fold_list,
    ncores = ncores,
    seed = seed
  )
  surv_rpart_optimizer$learner_args <- list(
    minsplit = 10L,
    maxdepth = 20L,
    cp = 0.03,
    method = "exp"
  )
  surv_rpart_optimizer$performance_metric <- c_index

  # set data
  surv_rpart_optimizer$set_data(
    x = train_x,
    y = train_y
  )

  surv_rpart_optimizer$execute()
}


## ------------------------------------------------
## Method `LearnerSurvRpartCox$new`
## ------------------------------------------------

if (requireNamespace("rpart", quietly = TRUE)) {
  LearnerSurvRpartCox$new()
}

}
\seealso{
\code{\link[rpart:rpart]{rpart::rpart()}}, \code{\link[=c_index]{c_index()}},
\code{\link[rpart:rpart.control]{rpart::rpart.control()}}

\code{\link[rpart:rpart]{rpart::rpart()}}, \code{\link[=c_index]{c_index()}},
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerSurvRpartCox}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerSurvRpartCox-new}{\code{LearnerSurvRpartCox$new()}}
\item \href{#method-LearnerSurvRpartCox-clone}{\code{LearnerSurvRpartCox$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvRpartCox-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvRpartCox-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerSurvRpartCox} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvRpartCox$new()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This learner is a wrapper around \code{\link[rpart:rpart]{rpart::rpart()}} in order to fit
recursive partitioning and regression trees with survival data.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (requireNamespace("rpart", quietly = TRUE)) {
  LearnerSurvRpartCox$new()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerSurvRpartCox-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerSurvRpartCox-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerSurvRpartCox$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
