#' Pancreatic Cancer Prevalence Data
#'
#' This dataset contains pancreatic cancer incidence rates across African countries.
#'
#' @format A data frame with the following variables:
#' \describe{
#'   \item{NAME}{Character. Name of the country.}
#'   \item{prevalence}{Numeric. Prevalence rate per 100,000 population.}
#'   \item{female}{Numeric. Female pancreatic cancer patients.}
#'   \item{male}{Numeric. Male pancreatic cancer patients.}
#'   \item{ageb}{Numeric. Patients age between 20-54 years.}
#'   \item{agec}{Numeric. Patients age above 55 years.}
#'   \item{agea}{Numeric. Patients age below 20 years.}
#'   \item{fageb}{Numeric. Female patients age between 20-54 years.}
#'   \item{fagec}{Numeric. Female patients age above 55 years.}
#'   \item{fagea}{Numeric. Female patients age below 20 years.}
#'   \item{mageb}{Numeric. Male patients age between 20-54 years.}
#'   \item{magec}{Numeric. Male patients age above 55 years.}
#'   \item{magea}{Numeric. Male patients age below 20 years.}
#'   \item{yra}{Numeric. Incidence rate in year 2017.}
#'   \item{yrb}{Numeric. Incidence rate in year 2018.}
#'   \item{yrc}{Numeric. Incidence rate in year 2019.}
#'   \item{yrd}{Numeric. Incidence rate in year 2020.}
#'   \item{yre}{Numeric. Incidence rate in year 2021.}
#' }
#'
#' @source Global Burden of Disease (GBD) 2021 estimates, Seattle, United States https://vizhub.healthdata.org/gbd-results/
#' @usage data(panc_prevalence)
#' @keywords datasets
#'
"panc_prevalence"
