% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectivity_funcs.R
\name{double_sigmoid_length}
\alias{double_sigmoid_length}
\title{Length based double-sigmoid selectivity function}
\usage{
double_sigmoid_length(w, l25, l50, l50_right, l25_right, species_params, ...)
}
\arguments{
\item{w}{Vector of sizes.}

\item{l25}{the length which gives a selectivity of 25\%.}

\item{l50}{the length which gives a selectivity of 50\%.}

\item{l50_right}{the length which gives a selectivity of 50\%.}

\item{l25_right}{the length which gives a selectivity of 25\%.}

\item{species_params}{A list with the species params for the current species.
Used to get at the length-weight parameters \code{a} and \code{b}}

\item{...}{Unused}
}
\value{
Vector of selectivities at the given sizes.
}
\description{
A hump-shaped selectivity function with a sigmoidal rise and an independent
sigmoidal drop-off. This drop-off is what distinguishes this from the
function \code{\link[=sigmoid_length]{sigmoid_length()}} and it is intended to model the escape of large
individuals from the fishing gear.
}
\details{
The selectivity is obtained as the product of two sigmoidal curves, one
rising and one dropping. The sigmoidal rise is based on the two parameters
\code{l25} and \code{l50} which determine the length at which 25\% and 50\% of
the stock is selected respectively. The sigmoidal drop-off is based on the
two parameters \code{l50_right} and \code{l25_right} which determine the
length at which the selectivity curve has dropped back to 50\% and 25\%
respectively. The selectivity is given by the function \deqn{S(l) =
\frac{1}{1 + \exp\left(\log(3)\frac{l50 -l}{l50 - l25}\right)}\frac{1}{1 +
\exp\left(\log(3)\frac{l50_{right} -l}{l50_{right} -
l25_{right}}\right)}}{S(l) = 1/(1 + exp(log(3)*(l50 -l) / (l50 - l25)))/(1
+ exp(log(3)*(l50 -l) / (l50 - l25)))}

As the size-based model is weight based, and this selectivity function is
length based, it uses the length-weight parameters \code{a} and \code{b} to convert
between length and weight. \deqn{l = \left(\frac{w}{a}\right)^{1/b}}{l =
(w/a)^(1/b)}
}
\seealso{
\code{\link[=gear_params]{gear_params()}} for setting the selectivity parameters.

Other selectivity functions: 
\code{\link{knife_edge}()},
\code{\link{sigmoid_length}()},
\code{\link{sigmoid_weight}()}
}
\concept{selectivity functions}
