% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaliq.R
\name{evaliq}
\alias{evaliq}
\title{Evaluate the Imputation Quality}
\usage{
evaliq(x.true, x.impute, plot = TRUE, interactive = FALSE)
}
\arguments{
\item{x.true}{a vector with true values.}

\item{x.impute}{a vector with estimated values.}

\item{plot}{a Boolean that indicates whether to plot or not.}

\item{interactive}{a Boolean that indicates whether to use interactive plot when the plot option is invoked (plot = "TRUE").}
}
\value{
rmse root mean squared error.

mae mean absolute error.

nrmse normalized root mean squared error.
}
\description{
Calculates Root Mean Squared Error (RMSE), Mean Absolute Error (MAE) and Normalized Root Mean Squared Error (NRMSE). It also performs visualization for imputation quality evaluation.
}
\examples{
# A very quick example
n <- 100
x.true <- rnorm(n)
x.est <- x.true
na.idx <- sample(1:n, 20)
x.est[na.idx] <- x.est[na.idx] + rnorm(length(na.idx), sd = 0.1)

# Default plot
er.eval <- evaliq(x.true[na.idx], x.est[na.idx])

# Interactive plot
er.eval <- evaliq(x.true[na.idx], x.est[na.idx], interactive = TRUE)

# Turn off plot
# All of the three case will return the value of error
er.eval <- evaliq(x.true[na.idx], x.est[na.idx], plot = FALSE)
er.eval


\donttest{
# Real data example
set.seed(0)
data(toxicity, package = "misspi")
toxicity.miss <- missar(toxicity, 0.4, 0.2)
# Please change ncore according to your computer
impute.res <- misspi(toxicity.miss, ncore = 1)
x.imputed <- impute.res$x.imputed

na.idx <- which(is.na(toxicity.miss))
evaliq(toxicity[na.idx], x.imputed[na.idx])
evaliq(toxicity[na.idx], x.imputed[na.idx], interactive = TRUE)}

}
\seealso{
\code{\link{misspi}}, \code{\link{missar}}
}
\author{
Zhongli Jiang \email{jiang548@purdue.edu}
}
