% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_to_dataframe.R
\name{lr_to_dataframe}
\alias{lr_to_dataframe}
\title{Convert Genetic LR Simulations to Data Frame}
\usage{
lr_to_dataframe(datasim)
}
\arguments{
\item{datasim}{A list object returned by \code{\link{sim_lr_genetic}},
containing \code{Unrelated} and \code{Related} components with LR objects.}
}
\value{
A data.frame with two columns:
\itemize{
\item \code{Unrelated}: Numeric LR values from H2 simulations
\item \code{Related}: Numeric LR values from H1 simulations
}
The number of rows equals the number of simulations.
}
\description{
Converts the list output from \code{\link{sim_lr_genetic}} into a tidy
data frame suitable for analysis and visualization. Extracts the total
LR values from each simulation.
}
\details{
The function extracts \code{LRtotal[["H1:H2"]]} from each LR object
in the simulation lists. This represents the overall likelihood ratio
across all genetic markers.
}
\examples{
library(forrel)

# Create pedigree and simulate
x <- linearPed(2)
x <- setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x <- profileSim(x, N = 1, ids = 2)

# Simulate LRs
lr_sims <- sim_lr_genetic(x, missing = 5, numsims = 50, seed = 123)

# Convert to dataframe
lr_df <- lr_to_dataframe(lr_sims)
head(lr_df)

# Now can use with other functions
summary(log10(lr_df$Related))
plot_lr_distribution(lr_df)
}
\references{
Marsico FL, Vigeland MD, Egeland T, Herrera Pinero F (2021). "Making
decisions in missing person identification cases with low statistical
power." \emph{Forensic Science International: Genetics}, 52, 102519.
\doi{10.1016/j.fsigen.2021.102519}
}
\seealso{
\code{\link{sim_lr_genetic}} for generating the input,
\code{\link{plot_lr_distribution}} for visualization,
\code{\link{lr_combine}} for combining with other LR sources.
}
