% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lr_birthdate.R
\name{lr_birthdate}
\alias{lr_birthdate}
\title{Likelihood Ratio for Birth Date}
\usage{
lr_birthdate(
  ABD = "1976-05-31",
  DBD = "1976-07-15",
  alpha = c(1, 4, 60, 11, 6, 4, 4),
  cuts = c(-120, -30, 30, 120, 240, 360),
  type = 1,
  PrelimData = NULL,
  draw = 500,
  seed = 123
)
}
\arguments{
\item{ABD}{Character or Date. Actual birth date of the missing person
in "YYYY-MM-DD" format. Default: "1976-05-31".}

\item{DBD}{Character or Date. Declared birth date of the person of
interest in "YYYY-MM-DD" format. Default: "1976-07-15".}

\item{alpha}{Numeric vector. Alpha parameters for the Dirichlet distribution,
typically representing frequencies of solved cases in each discrepancy
category. Length should be one more than length of \code{cuts}.
Default: c(1, 4, 60, 11, 6, 4, 4).}

\item{cuts}{Numeric vector. Cutoff values (in days) for categorizing the
difference between DBD and ABD. Creates length(cuts)+1 categories.
Default: c(-120, -30, 30, 120, 240, 360).}

\item{type}{Integer (1 or 2). Type of search scenario:
\itemize{
\item 1: Open search - MP may not be in database (uses uniform H2)
\item 2: Closed search - MP is in database (uses database frequencies)
}
Default: 1.}

\item{PrelimData}{Data.frame. Required when type = 2. Contains DBD column
for persons of interest in the database. Can be output from
\code{\link{sim_poi_prelim}}.}

\item{draw}{Integer. Number of Dirichlet samples for probability estimation.
Default: 500.}

\item{seed}{Integer. Random seed for reproducibility. Default: 123.}
}
\value{
Numeric. The likelihood ratio for the given birth date discrepancy.
Also printed to console.
}
\description{
Computes likelihood ratios (LRs) based on the discrepancy between the
actual birth date (ABD) of the missing person and the declared birth
date (DBD) of the person of interest. Uses Dirichlet distribution to
model category probabilities.
}
\details{
\strong{Categories:}
The difference between DBD and ABD (in days) is categorized using the
\code{cuts} vector. Default categories are:
\enumerate{
\item < -120 days (DBD more than 4 months before ABD)
\item -120 to -30 days
\item -30 to 30 days (close match)
\item 30 to 120 days
\item 120 to 240 days
\item 240 to 360 days
\item > 360 days (DBD more than 1 year after ABD)
}

\strong{Dirichlet Model:}
Uses method of moments to estimate category probabilities from Dirichlet
samples. The \code{alpha} parameter reflects prior knowledge from solved
cases about the distribution of birth date discrepancies.

\strong{LR Calculation:}
\itemize{
\item Type 1: LR = P(category | H1) / (1/n_categories)
\item Type 2: LR = P(category | H1) / P(category in database)
}
}
\examples{
# Type 1: Open search - close match (45 days difference)
lr1 <- lr_birthdate(
  ABD = "1976-05-31",
  DBD = "1976-07-15",
  type = 1,
  seed = 123
)

# Type 1: Open search - larger discrepancy
lr2 <- lr_birthdate(
  ABD = "1976-05-31",
  DBD = "1977-03-15",
  type = 1,
  seed = 123
)

\dontrun{
# Type 2: Closed search with database
# Requires a large database with varied birth dates
db <- sim_poi_prelim(numsims = 1000, seed = 456)
lr3 <- lr_birthdate(
  ABD = "1976-05-31",
  DBD = "1976-07-15",
  type = 2,
  PrelimData = db,
  seed = 123
)
}
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{sim_lr_prelim}} for simulating LR distributions,
\code{\link{sim_poi_prelim}} for generating preliminary databases.
}
