% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-management.R
\name{gintervals.dataset}
\alias{gintervals.dataset}
\title{Returns the database/dataset path for interval sets}
\usage{
gintervals.dataset(intervals = NULL)
}
\arguments{
\item{intervals}{interval set name or a vector of interval set names}
}
\value{
A character vector containing the database paths for each interval set.
Returns NA for interval sets that don't exist in any connected database.
}
\description{
Returns the path of the database or dataset containing an interval set.
}
\details{
When datasets are loaded, interval sets can come from either the working database
or from loaded datasets. This function returns the source path for each interval set.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gintervals.dataset("annotations1")

}
\seealso{
\code{\link{gintervals.dbs}}, \code{\link{gintervals.exists}},
\code{\link{gintervals.ls}}, \code{\link{gdataset.ls}}
}
\keyword{~database}
\keyword{~intervals}
\keyword{~path}
