% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnVR_wrappers.R
\name{lnVR_inter}
\alias{lnVR_inter}
\title{Interaction effect: Log Variability Ratio}
\usage{
lnVR_inter(
  data,
  col_names = c("yi", "vi"),
  append = TRUE,
  Ctrl_sd,
  Ctrl_n,
  A_sd,
  A_n,
  B_sd,
  B_n,
  AB_sd,
  AB_n
)
}
\arguments{
\item{data}{Data frame containing the variables used.}

\item{col_names}{Vector of two strings to name the output columns for the effect size and its sampling variance. Default is 'yi' and 'vi'.}

\item{append}{Logical. Append the results to \code{data}. Default is TRUE}

\item{Ctrl_sd}{Standard deviation from the control treatment}

\item{Ctrl_n}{Sample size from the control treatment}

\item{A_sd}{Standard deviation from the A treatment}

\item{A_n}{Sample size from the A treatment}

\item{B_sd}{Standard deviation from the B treatment}

\item{B_n}{Sample size from the B treatment}

\item{AB_sd}{Standard deviation from the interaction AxB treatment}

\item{AB_n}{Sample size from the interaction AxB treatment}
}
\value{
A data frame containing the effect sizes and their sampling variance.
By default, the columns are named \code{yi} (effect size) and \code{vi} (sampling variance).
If \code{append = TRUE}, the results are appended to the input \code{data}; otherwise, only the computed effect size columns are returned.
}
\description{
Computes the interaction of Factors A and B measured as
the log of the variability ratio.
}
\details{
See the package vignette for a detailed description of the formula.
}
\examples{
# Example for interaction effect in 2x2 factorial focusing on variability (Drought x Temperature)
data <- data.frame(
  study_id = 1:2,
  control_sd = c(1.8, 2.1), control_n = c(22, 19),
  drought_sd = c(2.6, 2.9), drought_n = c(20, 21),
  temperature_sd = c(2.0, 2.3), temperature_n = c(21, 18),
  drought_temp_sd = c(3.2, 3.6), drought_temp_n = c(19, 20)
)

result <- lnVR_inter(
  data = data,
  Ctrl_sd = "control_sd", Ctrl_n = "control_n",
  A_sd = "drought_sd", A_n = "drought_n", 
  B_sd = "temperature_sd", B_n = "temperature_n",
  AB_sd = "drought_temp_sd", AB_n = "drought_temp_n"
)

}
\author{
Facundo Decunta - fdecunta@agro.uba.ar
}
