
# Overview of the min2HalfFFD R Package

## Introduction

Welcome to **min2HalfFFD**, an intuitive and powerful R package designed
for statisticians, experimental scientists, and researchers working with
factorial experiments. This package generates all possible minimally
changed two-level half-fractional factorial designs along with various
statistical criteria to measure the performance of these designs through
a simple, user-friendly shiny app interface. It includes the function
`minimal.2halfFFD()`, which launches the interactive application where
you can explore, compare, and select suitable designs. This vignette
provides a quick overview of how to use the package and its shiny app
interface.

## What are Minimally Changed Factorial and Fractional Factorial Designs?

In many agricultural, post-harvest, engineering, industrial, and
processing experiments, changing factor levels between runs can be
physically difficult, time-consuming, or costly. Such experiments often
involve hard-to-change factors or require a normalization period before
stable operating conditions are reached. Because of these constraints,
experimenters prefer run orders that keep the number of factor level
changes to a minimum.

Minimally changed factorial and fractional factorial designs are
constructed to address this practical need. They arrange the sequence of
runs so that total factor changes are minimized, helping reduce
operational effort, conserve resources, and lower the overall cost of
experimentation.

This idea applies to both full factorial designs and fractional
factorial designs. When a full factorial design contains too many
treatment combinations to be feasible, a fractional factorial design—a
carefully selected subset of the full design—offers a practical
alternative.

## Minimally Changed Run Sequences in Half-Replicate of $2^k$ Fractional Factorial Designs

In Design of Experiments (DOE) theory, the two levels of a factor can be
represented as integers, e.g., –1 for the low level and 1 for the high
level. A half replicate of a $2^k$ Factorial Designs
($\tfrac{1}{2} \, 2^{k}$) with the minimum possible number of changes
can be constructed by first developing a $2^{\,k-1}$ factorial with
minimal level changes in its run orders, and then generating a new
factor by taking the product of all the 𝑘−1 factors in the constructed
$2^{\,k-1}$ design with minimally changed run orders, where 𝑘 is the
number of factors.

## Statistical Criteria for Evaluating Minimally Changed Designs

Minimally changed designs can be compared and assessed using several
quantitative criteria. These measures help identify designs that not
only reduce factor level changes but also maintain desirable statistical
properties for experimentation.

**$\mathrm{D}$-optimality criterion:** A $\mathrm{D}$-optimal design is
obtained by maximizing the determinant of the information matrix, or
equivalently, by minimizing the generalized variance

**$\mathrm{D}_{t}$-optimality criterion:** $\mathrm{D}_{t}$-optimality
criterion is found by minimizing the generalized variance or
equivalently maximizes the information in presence of trend effect

**Trend Factor:** The trend factor is defined as the ratio of the
$\mathrm{D}_{t}$-value to the $\mathrm{D}$-value for a particular run
order. For completely trend free design trend factor value will be 1 .
However, if the trend factor value is 0, then the design is completely
affected by time trend.

These three measures together help identify run orders that are not only
minimally changed but also statistically efficient and robust to
potential trend effects.

## Using the min2HalfFFD Package

### Install and Load the package

You can install **min2HalfFFD** from CRAN:

``` r
install.packages("min2HalfFFD")
# Load the package
library(min2HalfFFD)
```

### Launch the Shiny app

The interactive shiny app is the easiest way to explore and inspect
minimally changed designs.  
To open it from an interactive R session use:

``` r
library(min2HalfFFD)
# Run the function
minimal.2halfFFD()
```

<img src="vignettes/figures/app-screenshot.png" width="80%" style="display: block; margin: auto;" />

## Exploring the Shiny Interface

Once you launch the Shiny app with `minimal.2halfFFD()`, the interface
opens in your browser (or in the RStudio Viewer).  
The layout is designed for clarity and ease of use.

### 1. Input Panel

On the **left side**, you will find the input controls:

- **Enter Number of Factors**  
  Specify how many two-level factors your experiment has.  
  The number must be greater than 2.

- **Trend Factor Range**  
  Enter the acceptable range for the *Trend Factor* between 0 and 1.  
  For example: lower = 0.56, upper = 0.65.  
  The upper bound must be greater than the lower bound.

- **Generate Button**  
  Click **Generate** to start the design generation process.

### 2. Result Display Panel

After clicking *Generate*, the right side of the app displays the
results.  
The dropdown selector **“Select Result to Display”** allows you to
choose what to view:

- **Total Change** Displays the sum of per-factor level changes of a run
  order.

- **Total Number of Minimally Changed Designs**  
  Displays total number of all the minimally changed two-level
  half-fractional factorial designs.

- **All Minimally Changed Designs**  
  Shows all the minimally changed two-level half-fractional factorial
  designs.

- **All Minimally Changed Designs with D, Dt, Trend Factor**  
  Presents designs with corresponding D, Dt and Trend Factor values.

- **Maximum D Value**  
  Maximum D-value within the generated minimally changed designs.

- **D-Optimal Designs**  
  Designs with the Maximum D-value within the generated minimally
  changed designs.

- **Maximum Dt Value**  
  Maximum Dt-value within the generated minimally changed designs.

- **Dt-Optimal Designs** Designs with the Maximum Dt-value within the
  generated minimally changed designs.

- **Maximum Trend Factor** Displays the Maximum Trend Factor Value for
  the generated minimally changed designs.

- **Number of Minimally Changed Designs with Maximum Trend Factor
  Value** Shows Number of minimally changed designs with Maximum Trend
  Factor value

- **Minimally Changed Designs in Trend Factor Range** Shows Minimally
  changed designs within the specified range of trend factor

<img src="vignettes/figures/result-screenshot.png" width="80%" style="display: block; margin: auto;" />

<img src="vignettes/figures/result1-screenshot.png" width="80%" style="display: block; margin: auto;" />

## References

Bhowmik, A., Varghese, E., Jaggi, S., and Varghese, C. (2015).Factorial
experiments with minimum changes in run sequences.*Journal of the Indian
Society of Agricultural Statistics*, **69(3)**, 243–255.

Bhowmik, A., Varghese, E., Jaggi, S., and Varghese, C. (2017).Minimally
changed run sequences in factorial experiments.*Communications in
Statistics – Theory and Methods*, **46(15)**, 7444–7459.

Bhowmik, A., Varghese, E., Jaggi, S., and Varghese, C. (2020).On the
generation of factorial designs with minimum level
changes.*Communications in Statistics – Simulation and Computation*,
**51(6)**, 3400–3409.

Chanda, B., Bhowmik, A., Jaggi, S., Varghese, E., Datta, A., Varghese,
C.,Das Saha, N., Bhatia, A., and Chakrabarti, B. (2021). Minimal cost
multifactor experiments for agricultural research involving
hard-to-change factors.*Indian Journal of Agricultural Sciences*,
**91(7)**, 97–100.

Tack, L., and Vandebroek, M. (2001).(Dt, C)-optimal run orders.*Journal
of Statistical Planning and Inference*, **98**, 293-310.
