// ============================================================================
// RcppExports_eigen.cpp — Export RcppEigen/Rcpp routines for mgwrsar
// ============================================================================

#include "RcppIncludesEigen.h"
using namespace Rcpp;

// ---------------------------------------------------------------------------
// Prototypes of C++ interfaces (defined in mgwrsar.cpp)
// ---------------------------------------------------------------------------

Rcpp::NumericMatrix Proj_C(const Rcpp::NumericMatrix& HH,
                           const Rcpp::NumericMatrix& XX);

Rcpp::S4 Sl_C(double llambda,
              const Rcpp::S4& WW,
              bool iinv,
              bool aapprox);

Rcpp::NumericMatrix INST_C(const Rcpp::NumericMatrix& XX,
                           const Rcpp::S4& WW,
                           bool withlambda,
                           double llambda);

Rcpp::NumericVector PhWY_C(const Rcpp::NumericVector& YY,
                           const Rcpp::NumericMatrix& XX,
                           const Rcpp::S4& WW,
                           const Rcpp::NumericVector& Wi);

Rcpp::List QRcpp2_C(const Rcpp::NumericMatrix& AA,
                    const Rcpp::NumericMatrix& bb,
                    const Rcpp::NumericMatrix& cc);

Rcpp::S4 ApproxiW(const Rcpp::S4& WW,
                  double la,
                  int order);

Rcpp::List mod(const Rcpp::NumericVector& YY,
               const Rcpp::NumericMatrix& XX,
               const Rcpp::S4& WW,
               const Rcpp::NumericMatrix& XZZ,
               const Rcpp::NumericVector& YZZ,
               const Rcpp::NumericVector& Wi,
               const std::string& LocalInst,
               bool ismethodB2SLS,
               bool ismethodMGWRSAR_1_kc_0,
               bool SE_);


Rcpp::List knn_stable_sort(const Rcpp::NumericMatrix& dist,
                           const Rcpp::IntegerMatrix& idx);

Rcpp::List compute_DS_DT_cpp(
    const Rcpp::NumericMatrix& coords,
    const Rcpp::NumericVector& Time,
    const Rcpp::IntegerMatrix& indexG,
    bool cyclic,
    double cycling
);

// ---------------------------------------------------------------------------
// C Wrappers (SEXP) corresponding to .Call() calls generated by RcppExports.R
// ---------------------------------------------------------------------------

extern "C" {

  // Proj_C
  RcppExport SEXP _mgwrsar_Proj_C(SEXP HHSEXP, SEXP XXSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type HH(HHSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type XX(XXSEXP);
    rcpp_result_gen = Rcpp::wrap(Proj_C(HH, XX));
    return rcpp_result_gen;
    END_RCPP
  }

  // Sl_C
  RcppExport SEXP _mgwrsar_Sl_C(SEXP llambdaSEXP, SEXP WWSEXP,
                                SEXP iinvSEXP, SEXP aapproxSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< double >::type llambda(llambdaSEXP);
    Rcpp::traits::input_parameter< const Rcpp::S4& >::type WW(WWSEXP);
    Rcpp::traits::input_parameter< bool >::type iinv(iinvSEXP);
    Rcpp::traits::input_parameter< bool >::type aapprox(aapproxSEXP);
    rcpp_result_gen = Rcpp::wrap(Sl_C(llambda, WW, iinv, aapprox));
    return rcpp_result_gen;
    END_RCPP
  }

  // INST_C
  RcppExport SEXP _mgwrsar_INST_C(SEXP XXSEXP, SEXP WWSEXP,
                                  SEXP withlambdaSEXP, SEXP llambdaSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type XX(XXSEXP);
    Rcpp::traits::input_parameter< const Rcpp::S4& >::type WW(WWSEXP);
    Rcpp::traits::input_parameter< bool >::type withlambda(withlambdaSEXP);
    Rcpp::traits::input_parameter< double >::type llambda(llambdaSEXP);
    rcpp_result_gen = Rcpp::wrap(
      INST_C(XX, WW, withlambda, llambda)
    );
    return rcpp_result_gen;
    END_RCPP
  }

  // PhWY_C
  RcppExport SEXP _mgwrsar_PhWY_C(SEXP YYSEXP, SEXP XXSEXP,
                                  SEXP WWSEXP, SEXP WiSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type YY(YYSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type XX(XXSEXP);
    Rcpp::traits::input_parameter< const Rcpp::S4& >::type WW(WWSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type Wi(WiSEXP);
    rcpp_result_gen = Rcpp::wrap(
      PhWY_C(YY, XX, WW, Wi)
    );
    return rcpp_result_gen;
    END_RCPP
  }

  // QRcpp2_C
  RcppExport SEXP _mgwrsar_QRcpp2_C(SEXP AASEXP, SEXP bbSEXP, SEXP ccSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type AA(AASEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type bb(bbSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type cc(ccSEXP);
    rcpp_result_gen = Rcpp::wrap(
      QRcpp2_C(AA, bb, cc)
    );
    return rcpp_result_gen;
    END_RCPP
  }

  // ApproxiW
  RcppExport SEXP _mgwrsar_ApproxiW(SEXP WWSEXP, SEXP laSEXP, SEXP orderSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::S4& >::type WW(WWSEXP);
    Rcpp::traits::input_parameter< double >::type la(laSEXP);
    Rcpp::traits::input_parameter< int >::type order(orderSEXP);
    rcpp_result_gen = Rcpp::wrap(
      ApproxiW(WW, la, order)
    );
    return rcpp_result_gen;
    END_RCPP
  }

  // mod
  RcppExport SEXP _mgwrsar_mod(SEXP YYSEXP, SEXP XXSEXP, SEXP WWSEXP,
                               SEXP XZZSEXP, SEXP YZZSEXP, SEXP WiSEXP,
                               SEXP LocalInstSEXP,
                               SEXP ismethodB2SLSSEXP,
                               SEXP ismethodMGWRSAR_1_kc_0SEXP,
                               SEXP SE_SEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type YY(YYSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type XX(XXSEXP);
    Rcpp::traits::input_parameter< const Rcpp::S4& >::type WW(WWSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type XZZ(XZZSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type YZZ(YZZSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type Wi(WiSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type LocalInst(LocalInstSEXP);
    Rcpp::traits::input_parameter< bool >::type ismethodB2SLS(ismethodB2SLSSEXP);
    Rcpp::traits::input_parameter< bool >::type ismethodMGWRSAR_1_kc_0(ismethodMGWRSAR_1_kc_0SEXP);
    Rcpp::traits::input_parameter< bool >::type SE_(SE_SEXP);
    rcpp_result_gen = Rcpp::wrap(
      mod(YY, XX, WW, XZZ, YZZ, Wi,
          LocalInst, ismethodB2SLS, ismethodMGWRSAR_1_kc_0, SE_)
    );
    return rcpp_result_gen;
    END_RCPP
  }


  // knn_stable_sort
  RcppExport SEXP _mgwrsar_knn_stable_sort(SEXP distSEXP,
                                           SEXP idxSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type dist(distSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerMatrix& >::type idx(idxSEXP);
    rcpp_result_gen = Rcpp::wrap(
      knn_stable_sort(dist, idx)
    );
    return rcpp_result_gen;
    END_RCPP
  }

  // compute_DS_DT_cpp
  RcppExport SEXP _mgwrsar_compute_DS_DT_cpp(SEXP coordsSEXP,
                                             SEXP TimeSEXP,
                                             SEXP indexGSEXP,
                                             SEXP cyclicSEXP,
                                             SEXP cyclingSEXP) {
    BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;

    Rcpp::traits::input_parameter< const Rcpp::NumericMatrix& >::type coords(coordsSEXP);
    Rcpp::traits::input_parameter< const Rcpp::NumericVector& >::type Time(TimeSEXP);
    Rcpp::traits::input_parameter< const Rcpp::IntegerMatrix& >::type indexG(indexGSEXP);
    Rcpp::traits::input_parameter< bool >::type cyclic(cyclicSEXP);
    Rcpp::traits::input_parameter< double >::type cycling(cyclingSEXP);

    rcpp_result_gen = Rcpp::wrap(
      compute_DS_DT_cpp(coords, Time, indexG, cyclic, cycling)
    );

    return rcpp_result_gen;
    END_RCPP
  }

} // extern "C"
