% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg_weibull.R
\name{rweibullcox}
\alias{rweibullcox}
\title{Simulate observations from a Weibull distribution}
\usage{
rweibullcox(n, rate, shape)
}
\arguments{
\item{n}{(integer) number of observations}

\item{rate}{(numeric) rate parameter (can be a vector of size n)}

\item{shape}{(numeric) shape parameter (can be a vector of size n)}
}
\description{
Simulate observations from the model with cumulative hazard
  given by \deqn{\Lambda(t) = \lambda\cdot t^s} where \eqn{\lambda} is the
  \emph{rate parameter} and \eqn{s} is the \emph{shape parameter}.
}
\details{
[stats::rweibull()] uses a different parametrization with
  cumulative hazard given by
\deqn{H(t) = (t/b)^a,}
i.e., the shape is the same \eqn{a:=s} but the scale paramter \eqn{b}
is related to rate paramter \eqn{r} by
\deqn{r := b^{-a}}
}
\seealso{
[stats::rweibull()]
}
