% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cifreg.R
\name{cifreg}
\alias{cifreg}
\alias{vecAllStrata}
\alias{diffstrata}
\alias{FGprediid}
\alias{indexstratarightR}
\alias{gofFG}
\alias{cifregFG}
\title{CIF regression}
\usage{
cifreg(
  formula,
  data,
  propodds = 1,
  cause = 1,
  cens.code = 0,
  no.codes = NULL,
  death.code = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with 'Event' outcome}

\item{data}{data frame}

\item{propodds}{to fit logit link model, and propodds=NULL to fit Fine-Gray model}

\item{cause}{of interest}

\item{cens.code}{code of censoring}

\item{no.codes}{certain event codes to be ignored when finding competing causes, can be used with administrative censoring.}

\item{death.code}{can also specify death.code (in addition to cause) to overrule default which takes all remaining codes (minus cause,cens.code,no.codes)}

\item{...}{Additional arguments to recreg}
}
\description{
CIF logistic-link for propodds=1 default and CIF Fine-Gray (cloglog) regression for propodds=NULL. The
FG model can also be called using the cifregFG function that has propodds=NULL.
}
\details{
For FG model:
\deqn{
\int (X - E ) Y_1(t) w(t) dM_1
}
is computed and summed over clusters and returned multiplied with inverse
of second derivative as iid.naive. Here \deqn{w(t) = G(t) (I(T_i \wedge t < C_i)/G_c(T_i \wedge t))} and
\deqn{E(t) = S_1(t)/S_0(t)} and \deqn{S_j(t) = \sum X_i^j Y_{i1}(t) w_i(t) \exp(X_i^T \beta)}.

The iid decomposition of the beta's, however, also have a censoring term that is also
is computed and added (still scaled with inverse second derivative)
\deqn{
\int (X - E ) Y_1(t) w(t) dM_1 + \int q(s)/p(s) dM_c
}
and returned as the iid 

For logistic link standard errors are slightly to small since uncertainty from recursive baseline is not considered, so for smaller
data-sets it is recommended to use the prop.odds.subdist of timereg that is also more efficient due to use of different weights for
the estimating equations. Alternatively, one can also bootstrap the standard errors.
}
\examples{
## data with no ties
library(mets)
data(bmt,package="mets")
bmt$time <- bmt$time+runif(nrow(bmt))*0.01
bmt$id <- 1:nrow(bmt)

## logistic link  OR interpretation
or=cifreg(Event(time,cause)~tcell+platelet+age,data=bmt,cause=1)
summary(or)
par(mfrow=c(1,2))
plot(or)
nd <- data.frame(tcell=c(1,0),platelet=0,age=0)
por <- predict(or,nd)
plot(por)

## approximate standard errors 
por <-mets:::predict.phreg(or,nd)
plot(por,se=1)

## Fine-Gray model
fg=cifregFG(Event(time,cause)~tcell+platelet+age,data=bmt,cause=1)
summary(fg)
##fg=recreg(Event(time,cause)~tcell+platelet+age,data=bmt,cause=1,death.code=2)
##summary(fg)
plot(fg)
nd <- data.frame(tcell=c(1,0),platelet=0,age=0)
pfg <- predict(fg,nd,se=1)
plot(pfg,se=1)

## bt <- iidBaseline(fg,time=30)
## bt <- IIDrecreg(fg$cox.prep,fg,time=30)

## not run to avoid timing issues
## gofFG(Event(time,cause)~tcell+platelet+age,data=bmt,cause=1)

sfg <- cifregFG(Event(time,cause)~strata(tcell)+platelet+age,data=bmt,cause=1)
summary(sfg)
plot(sfg)

### predictions with CI based on iid decomposition of baseline and beta
### these are used in the predict function above
fg <- cifregFG(Event(time,cause)~tcell+platelet+age,data=bmt,cause=1)
Biid <- iidBaseline(fg,time=20)
pfg1 <- FGprediid(Biid,nd)
pfg1
}
\author{
Thomas Scheike
}
