% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_github_repo_summary}
\alias{get_github_repo_summary}
\title{Collect repository summary metrics}
\usage{
get_github_repo_summary(
  repo,
  token = NULL,
  count = 1e+05,
  data_format = "dataframe",
  github_stats = "all"
)
}
\arguments{
\item{repo}{The repository name.
So for `https://github.com/ottrproject/metricminer`,
it would be `ottrproject/metricminer`}

\item{token}{You can provide the Personal Access Token key directly or this
function will attempt to grab a PAT that was stored using the
`authorize("github")` function}

\item{count}{How many items would you like to receive? default is 100000}

\item{data_format}{Default is to return a curated data frame. However if
you'd like to see the raw information returned from GitHub set format to
"raw".}

\item{github_stats}{Which stats would you like to collect from the GitHub
API?
Argument should be a vector of the names of the stats to be collected.
This differs whether time_course is TRUE/FALSE.
If time_course = FALSE should be a vector that can include:
"repo_activity", "stars", "forks", "contributors", "community"
If time_course = TRUE should be a vector that can include: "clones" and
"views".
By default "all" will be collected.}
}
\value{
GitHub repository summary metrics
}
\description{
This is a wrapper for \code{\link{get_github_metrics}} that has
`time_course = FALSE` so that summary metrics are collected

This is a function to get the information about a repository
}
\examples{
\dontrun{

authorize("github")

summary_metrics <- get_github_repo_summary(repo = "ottrproject/metricminer")
}
}
