% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{summary_featuretable}
\alias{summary_featuretable}
\title{General information about a feature table and sample-wise summary}
\usage{
summary_featuretable(
  data,
  n_samples_max = 5,
  n_features_max = 5,
  n_groups_max = 5,
  n_batches_max = 5
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{n_samples_max}{How many Samples should be printed to the console?}

\item{n_features_max}{How many Features should be printed to the console?}

\item{n_groups_max}{How many groups should be printed to the console?}

\item{n_batches_max}{How many Batches should be printed to the console?}
}
\value{
A sample-wise summary as a list.
}
\description{
Information about a feature table. Prints information to the console (number of samples, number of features and if applicable number of groups,
replicates and batches) and returns a sample-wise summary as a list.
}
\examples{
toy_metaboscape \%>\%
  join_metadata(toy_metaboscape_metadata) \%>\%
  summary_featuretable()
}
