% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaDigitise.R
\name{process_new_files}
\alias{process_new_files}
\title{process_new_files}
\usage{
process_new_files(dir, summary = TRUE, cex)
}
\arguments{
\item{dir}{the path name to the directory / folder where the files are located}

\item{summary}{summary = TRUE or FALSE is most relevant as it will print a simple summary statistics that are the same across all files}

\item{cex}{relative size of points and text in replotting of digitisation.}
}
\description{
Batch processes image files within a set directory, consolidates the data and exports the data for each image and type
}
\examples{
\donttest{
# temporary directory
tmp_dir <- tempdir()

# Simulate data
set.seed(103)
x <- rnorm(20,0,1)
y <- rnorm(20,0,1)
means <- c(mean(x),mean(y))
ses <- c(sd(x)/sqrt(length(x))*1.96, sd(y)/sqrt(length(y))*1.96)

#Generate mock mean error plot
png(filename = paste0(tmp_dir,"/mean_error.png"), width = 480, height = 480)
plot(means, ylim = c(min(means-ses)-0.1,max(means+ses)+0.1), xlim=c(0.5,2.5), 
xaxt="n", pch=19, cex=2, ylab="Variable +/- SE", xlab="Treatment", main="Mean Error")
arrows(1:length(means),means+ses, 1:length(means), means-ses, code=3, angle=90, length=0.1)
axis(1,1:length(means),names(means))
dev.off()

\dontrun{
#metaDigitise figures
	data <- process_new_files(paste0(tmp_dir, "/"), summary = TRUE, cex = 2)
}
}
}
\author{
Joel Pick - joel.l.pick@gmail.com

Daniel Noble - daniel.wa.noble@gmail.com
}
