% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H_h.R
\name{H_h}
\alias{H_h}
\title{Global daily insolation on Mars horizontal surface}
\usage{
H_h(
  Ls,
  phi,
  longitude,
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau)
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}
}
\value{
Global daily insolation [Wh/m²-day]
}
\description{
Calculates the total solar energy received over a full Martian day on a horizontal surface.
Obtained by integrating global hourly insolation from sunrise to sunset.
}
