% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maraca.R
\name{plot.maraca}
\alias{plot.maraca}
\title{Generic function to plot the maraca object using plot().}
\usage{
\method{plot}{maraca}(
  x,
  continuous_grid_spacing_x = 10,
  trans = c("identity", "log", "log10", "sqrt", "reverse")[1],
  density_plot_type = c("default", "violin", "box", "scatter")[1],
  vline_type = NULL,
  remove_outliers = FALSE,
  theme = "maraca",
  ...
)
}
\arguments{
\item{x}{An object of S3 class 'maraca'.}

\item{continuous_grid_spacing_x}{The spacing of the x grid to use for the
continuous section of the plot.}

\item{trans}{the transformation to apply to the x-axis scale for the last
outcome. Possible values are "identity", "log" (only for continuous
endpoint), "log10" (only for continuous endpoint), "sqrt" (only for
continuous endpoint) and "reverse". The default value is "identity".}

\item{density_plot_type}{The type of plot to use to represent the density.
Accepts "default", "violin", "box" and "scatter".}

\item{vline_type}{what the vertical dashed line should represent. Accepts
"median" (only for continuous last endpoint), "mean", "none" and
NULL (default). By default (vline_type = NULL), vline_type will be
set to "median" for a continuous last endpoint and to "mean" for
a binary last endpoint.}

\item{remove_outliers}{Flag indicating for last endpoint if outliers are
supposed to be displayed. If TRUE, the outliers are removed and
only the range not including them is displayed. Only implemented
for continuous endpoints. Default value FALSE.}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "maraca_old", "color1", "color2" and none".
For more details, check the vignette called
"Maraca Plots - Themes and Styling".}

\item{\dots}{not used}
}
\value{
Returns ggplot2 plot of the maraca object.
}
\description{
Generic function to plot the maraca object using plot().
}
\examples{
data(hce_scenario_a)
hce_test <- maraca(
  data = hce_scenario_a,
  step_outcomes = c("Outcome I", "Outcome II", "Outcome III", "Outcome IV"),
  last_outcome = "Continuous outcome",
  fixed_followup_days = 3 * 365,
  column_names = c(outcome = "GROUP", arm = "TRTP", value = "AVAL0"),
  arm_levels = c(active = "Active", control = "Control"),
  compute_win_odds = TRUE
)
plot(hce_test)

}
