% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_tile3d.R
\name{add_cesium}
\alias{add_cesium}
\title{Add Cesium}
\usage{
add_cesium(map, data, point_size = 2, layer_id = NULL, ion_token = NULL)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be
EPSG:4326 (WGS 84) coordinate system}

\item{point_size}{size of point in pixels}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{ion_token}{ion asset token}
}
\description{
Renders 3D tiles data from Cesium ION assets. To use this layer you need a
Cesium ION account \url{https://cesium.com/learn/cesiumjs-learn/cesiumjs-quickstart/#your-first-app}.
This layer is experimental
}
\examples{
\donttest{

## Melbourne point cloud
ion_asset <- 43978
ion_token <- "ION_TOKEN"
tile_data <- paste0("https://assets.ion.cesium.com/",ion_asset,"/tileset.json")

mapdeck(
  location = c(144.95, -37.82)
  , zoom = 14
  , pitch = 60
) \%>\%
 add_cesium(
   data = tile_data
   , ion_token = ion_token
 )

}

}
