\name{expression}
\alias{expression_}
\encoding{UTF-8}
\title{Evaluate Formula Expressions on Data Subsets}
\description{
The core engine for Non-Standard Evaluation within \code{m61r}. \code{expression_} evaluates a user-provided formula within the context of a data frame, optionally for calculated groups.
The result relies on the Base R functions \code{\link[base]{with}} and \code{\link[base]{eval}}.
}
\usage{
# expression_(df, group_info = NULL, fun_expr)
}
\arguments{
\item{df}{data.frame}
\item{group_info}{An optional list of grouping indices and keys, typically generated by \code{get_group_indices_()}. If \code{NULL}, the expression runs over the entire \code{df}.}
\item{fun_expr}{A formula (\code{~<expression>}) that describes the R code to be executed.}
}
\value{
The function returns a list.
\itemize{
\item If \code{group_info} is \code{NULL}, the list contains the result of \code{fun_expr} executed on the entire \code{df}.
\item If \code{group_info} is provided, the list contains the results of \code{fun_expr} executed on each group's subset of the \code{df}.
}
}
\examples{
# Non-Grouped Evaluation (for mutate)
expression_(CO2,fun_expr=~conc/uptake)

# Grouped Evaluation (for summarise)
group_info <- get_group_indices_(CO2, ~Type)
expression_(CO2, group_info = group_info, fun_expr=~mean(uptake))

# Complex Grouped Evaluation (results in a list per group)
expression_(CO2, group_info = group_info, fun_expr=~lm(uptake~conc))
}
\keyword{m61r}
\keyword{evaluation}