% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-ag-news-sample.R
\docType{data}
\name{ag_news_sample}
\alias{ag_news_sample}
\title{AG News classification sample}
\format{
A data frame with 100 rows and 3 character columns:
\describe{
  \item{class}{News topic label (\code{"World"}, \code{"Sports"}, \code{"Business"}, or \code{"Sci/Tech"}).}
  \item{title}{Headline of the news article.}
  \item{description}{Short description for the article.}
}
}
\source{
Zhang, X., Zhao, J., & LeCun, Y. (2015). "Character-level Convolutional
Networks for Text Classification." arXiv:1509.01626. Original data distributed
via the AG News Topic Classification dataset.
}
\usage{
data(ag_news_sample)
}
\description{
A 100-row subset of the AG News Topic Classification dataset consisting of
25 documents from each of the four classes (World, Sports, Business,
Sci/Tech). The sample is intended for quick demonstrations and tests without
requiring the full external dataset.
}
\details{
The sample was obtained from \code{textdata::dataset_ag_news()} (Zhang et al.,
2015) using a fixed random seed to ensure reproducibility. It is provided
solely for illustrative purposes.
}
\seealso{
[textdata::dataset_ag_news()]
}
\keyword{datasets}
