% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{dc_poly}
\alias{dc_poly}
\title{Washington, D.C. Census Tract Data (ACS 2020)}
\format{
An `sf` data frame with 206 observations and 5 variables:
\describe{
  \item{GEOID}{Unique identifier for the census tract (character)}
  \item{NAME}{Census tract name and jurisdiction (character)}
  \item{geometry}{Polygon geometry representing the tract boundaries (`\code{sfc_POLYGON}`)}
  \item{B01003_001}{Total population of the tract (numeric)}
  \item{B19013_001}{Median household income of the tract (numeric, in USD)}
}
}
\source{
Data taken from the \pkg{bivariateLeaflet} package version 0.1.0
}
\usage{
data(dc_poly)
}
\description{
This dataset, `dc_poly`, is an `sf` object containing population and median
household income information for census tracts in Washington, D.C., based on
the 2020 American Community Survey (ACS). It also includes spatial polygon
geometries, allowing the data to be used directly for mapping and spatial
analysis, such as creating choropleth maps of demographic and socioeconomic
indicators.
}
\details{
The dataset consists of 206 observations (census tracts) and 5 variables.
The geometry column contains polygon boundaries for each tract.

The dataset name has been kept as `dc_poly` to avoid confusion with other
datasets in the R ecosystem. This naming convention helps distinguish this
dataset as part of the `lightsf` package and assists users in identifying
its specific characteristics. The original content has not been modified in
any way.
}
