% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluation}
\alias{evaluation}
\title{Numerical evaluation for different estimation methods.}
\usage{
evaluation(
  genfun,
  estfun_1,
  estfun_2,
  grid_list,
  nrep = 100,
  showplot = FALSE,
  cores = detectCores(),
  ...
)
}
\arguments{
\item{genfun}{A data generation function.}

\item{estfun_1}{A function for first estimation method.}

\item{estfun_2}{A function for second estimation method.}

\item{grid_list}{A list for grid points to be evaluated (each element of list is a vector represents ticklabels on a dimension). The number of list elements are the dimension of function inputs.}

\item{nrep}{Number of replications in simulation.}

\item{showplot}{Logical indicator. \code{showplot = TRUE} generates the heatmaps of output arrays. NULL if \code{showplot = FALSE}.}

\item{cores}{The numbers of cores (threads) of your machine to conduct parallel computing.}

\item{...}{Other inputs for data generation or estimation functions to be passed through.}
}
\value{
\code{evaluation} returns
\itemize{
     \item meanAE_1: An array for mean absolute error of first estimation method.
     \item meanAE_2: An array for mean absolute error of second estimation method.
     \item medianAE_1: An array for median absolute error of first estimation method.
     \item medianAE_2: An array for median absolute error of second estimation method.
     \item maxAE_1: An array for maximum absolute error of first estimation method.
     \item maxAE_2: An array for maximum absolute error of second estimation method.
     \item meanAE_diff: An array for mean absolute error of difference between two estimations.
     \item medianAE_diff: An array for median absolute error of difference between two estimations.
     \item maxAE_diff: An array for maximum absolute error of difference between two estimations.
     \item mediantime_1: An array for median time of first estimation method.
     \item mediantime_2: An array for median time of second estimation method.
     \item plot_meanAE_1: A plot for mean absolute error of first estimation method.
     \item plot_meanAE_2: A plot for mean absolute error of second estimation method.
     \item plot_medianAE_1: A plot for median absolute error of first estimation method.
     \item plot_medianAE_2: A plot for median absolute error of second estimation method.
     \item plot_maxAE_1: A plot for maximum absolute error of first estimation method.
     \item plot_maxAE_2: A plot for maximum absolute error of second estimation method.
     \item plot_meanAE_diff: A plot for mean absolute error of difference between two estimations.
     \item plot_medianAE_diff: A plot for median absolute error of difference between two estimations.
     \item plot_maxAE_diff: A plot for maximum absolute error of difference between two estimations.
     \item plot_mediantime_1: A plot for median time of first estimation method.
     \item plot_mediantime_2: A plot for median time of second estimation method.
}
}
\description{
Speed and accuracy comparison of two different estimation methods.
}
