% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu.R
\name{kuzu_get_column_names}
\alias{kuzu_get_column_names}
\title{Get Column Names from a Query Result}
\usage{
kuzu_get_column_names(result)
}
\arguments{
\item{result}{A Kuzu query result object.}
}
\value{
A character vector of column names.
}
\description{
Retrieves the names of the columns in a Kuzu query result.
}
\examples{
\donttest{
conn <- kuzu_connection(":memory:")
kuzu_execute(conn, "CREATE NODE TABLE User(name STRING, age INT64,
PRIMARY KEY (name))")
kuzu_execute(conn, "CREATE (:User {name: 'Alice', age: 25})")
result <- kuzu_execute(conn, "MATCH (a:User) RETURN a.name, a.age")
kuzu_get_column_names(result)
}
}
