% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_duplicate_names}
\alias{check_duplicate_names}
\title{Check if vars in dt have duplicate names}
\usage{
check_duplicate_names(dt, name)
}
\arguments{
\item{dt}{data.frame to check}

\item{name}{var name to check if has duplicates in dt}
}
\value{
logical either TRUE, if any duplicates are found, or FALSE otherwise
}
\description{
Check if vars in dt have duplicate names
}
\examples{
\dontrun{
# When no duplicates
x1 = data.table(id = c(1L, 1L, 2L, 3L, NA_integer_),
                t  = c(1L, 2L, 1L, 2L, NA_integer_),
                x  = 11:15)
joyn:::check_duplicate_names(x1, "x")

# When duplicates
x1_duplicates = data.frame(id = c(1L, 1L, 2L, 3L, NA_integer_),
                           x  = c(1L, 2L, 1L, 2L, NA_integer_),
                           x  = 11:15,
                           check.names = FALSE)
joyn:::check_duplicate_names(x1_duplicates, "x")
}
}
\keyword{internal}
