% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_ranks}
\alias{set_ranks}
\title{Set ranks for samples}
\usage{
set_ranks(tables, ranks, default = 1)
}
\arguments{
\item{tables}{A list of tables (samples, phylogeny, compositions, ranks)}

\item{ranks}{A named list of ranks for each sample}

\item{default}{The default rank to use when a sample is not in the rank list
(default: 1)}
}
\value{
A list of tables with ranks set for each sample
}
\description{
Given a list of jellyfish input tables and a named list of ranks for each
sample, set the rank for each sample.
}
\examples{
jellyfisher_example_tables |>
  select_patients("EOC809") |>
  set_ranks(list("EOC809_r1Bow1_DNA1" = 2, "EOC809_p2Per1_cO_DNA2" = 2),
    default = 1
  ) |>
  jellyfisher()

}
