% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_sumspectra.R
\name{itrax_sumspectra}
\alias{itrax_sumspectra}
\title{Create arbitrary sumspectra files}
\usage{
itrax_sumspectra(
  sumspectra_file = "CD166_19_S1/CD166_19_S1/sumspectra.spe",
  input_zip_folder = "CD166_19_S1/CD166_19_S1/XRF Data.zip",
  input_files = c("L000001.spe", "L000002.spe"),
  output_file = "mySumspectra.spe",
  method = mean
)
}
\arguments{
\item{sumspectra_file}{defines the name of the `sumspectra.spe` file to copy the header from}

\item{input_zip_folder}{defines the zip file to search in for the chosen `*.spe` files}

\item{input_files}{a character vector of filenames in the format `Lnnnnnn.spe` to use in the function}

\item{output_file}{defines the filename of the new sumspectra file}

\item{method}{one of `mean` (useful for generating pseudo `*.spe` files for calibration) or `sum` (a more exact recreation of the `sumspectra.spe` format)}
}
\value{
a tab-delimited file in a format compatible with a `sumspectra.spe` file
}
\description{
Parses data from a zipped collection of *.spe files to generate arbitrary sumspectra files from a defined input list
}
\examples{
\dontrun{itrax_sumspectra(sumspectra = "CD166_19_S1/CD166_19_S1/sumspectra.spe",
                          input_zip_folder = "CD166_19_S1/CD166_19_S1/XRF Data.zip",
                          input_files = CD166_19_xrf \%>\%
                            select(filename, depth) \%>\%
                            filter(depth >= 100 & depth <= 105) \%>\%
                            mutate(filename = str_split_i(filename, 
                              pattern = "XRF data\\\\\\\\", 
                              i = 2)
                              ) \%>\% 
                              pull(filename),
                            output_file = "sumspectra_100_105.spe",
                            method = mean)}

}
