% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clint_L4}
\alias{clint_L4}
\title{Clint Level-4 Example Data set}
\format{
A level-4 data.frame with 3 rows and 12 variables: \describe{
\item{\code{Compound.Name}}{Name of the test analyte/compound}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard - CCD)}
\item{\code{Lab.Compound.Name}}{Compound as described in the laboratory}
\item{\code{Clint.1.Med}}{Median intrinsic hepatic clearance at 1 uM}
\item{\code{Clint.1.Low}}{2.5th quantile of intrinsic hepatic clearance at 1 uM}
\item{\code{Clint.1.High}}{97.5th quantile of intrinsic hepatic clearance at 1 uM}
\item{\code{Clint.10.Med}}{Median of intrinsic hepatic clearance at 10 uM}
\item{\code{Clint.10.Low}}{2.5th quantile of intrinsic hepatic clearance at 10 uM}
\item{\code{Clint.10.High}}{97.5th quantile of intrinsic hepatic clearance at 1 uM}
\item{\code{Clint.pValue}}{Probability that a decrease is observed}
\item{\code{Sat.pValue}}{Saturation probability that a lower \code{Clint} is observed at a higher concentration}
\item{\code{degrades.pValue}}{Probability of abiotic degradation}
}
}
\usage{
clint_L4
}
\description{
Mass Spectrometry measurements of intrinsic hepatic clearance (Clint) for cryopreserved 
pooled human hepatocytes. Chemicals were per- and poly-fluorinated alkyl substance
(PFAS) samples. The experiments were led by Dr.s Marci Smeltz and Barbara Wetmore 
\insertCite{smeltz2023plasma}{invitroTKstats}. This data set is a subset of 
experimental data containing samples for 3 test analytes/compounds.
}
\references{
\insertRef{shibata2002prediction}{invitroTKstats}

\insertRef{smeltz2023plasma}{invitroTKstats}
}
\keyword{datasets}
