% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_annotation.R
\name{dbAnnotate}
\alias{dbAnnotate}
\title{Annotate clonotypes in immune repertoires using clonotype databases (e.g., VDJDB, McPAS)}
\usage{
dbAnnotate(.data, .db, .data.col, .db.col)
}
\arguments{
\item{.data}{The data to process. It can be a \link{data.frame}, a
\link[data.table:data.table]{data.table::data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.db}{A data frame or a data table with an immune receptor database. See \link{dbLoad} on how to load databases into R.}

\item{.data.col}{Character vector. Vector of columns in the input repertoires to use for clonotype search. E.g., \code{"CDR3.aa"} or \code{c("CDR3.aa", "V.name")}.}

\item{.db.col}{Character vector. Vector of columns in the database to use for clonotype search. The order must match the order of ".data.col".
E.g., if ".data.col" is \code{c("CDR3.aa", "V.name")}, then ".db.col" must have the exact order of columns. i.e., the first column must correspond
to CDR3 amino acid sequences, and the second column must correspond to V gene segment names.}
}
\value{
Data frame with input sequences and counts or proportions for each of the input repertoire.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Annotate clonotypes by matching them to known condition-associated immune receptors in a database.
Before using this function, you must download or load the relevant database files.
For more information, see the \href{https://immunarch.com/articles/web_only/v11_db.html}{online tutorial}.
}
\examples{
data(immdata)

#' # Example file path
file_path <- paste0(system.file(package = "immunarch"), "/extdata/db/vdjdb.example.txt")

# Load the database with human-only TRB-only receptors for all known antigens
db <- dbLoad(file_path, "vdjdb", "HomoSapiens", "TRB")

res <- dbAnnotate(immdata$data, db, "CDR3.aa", "cdr3")
res
}
\concept{annotation}
