% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bedload.R
\name{bedload_SJ}
\alias{bedload_SJ}
\title{Bedload Transport Capacity (Smart and Jaeggi)}
\usage{
bedload_SJ(d30, dm, d90, J, Rs, um, B, t_crit = 0.05, rho_s = 2650,
s_value = 2.65)
}
\arguments{
\item{d30}{Grain size distribution parameter [m].}

\item{dm}{Median grain size [m].}

\item{d90}{Grain size distribution parameter [m].}

\item{J}{Bottom slope [-].}

\item{Rs}{Hydraulic radius [m].}

\item{um}{Mean flow velocity [m/s].}

\item{B}{Bottom width [m].}

\item{t_crit}{Critical shear stress [-] (default: 0.05).}

\item{rho_s}{Density of bedload material [kg/m3] (default: 2650).}

\item{s_value}{Relative solid density [-] (default: 2.65).}
}
\value{
bedload_SJ returns the bedload transport rate [kg/s]
}
\description{
Calculates the bedload transport capacity based on the formula by Smart and
Jaeggi (1983). This formula is recommended for slopes between 0.005 and 0.2.
}
\examples{
d30 <- 0.05
dm <- 0.1
d90 <- 0.2
J <- 0.03
Rs <- 1
um <- 2
B <- 3

bedload_SJ(d30 = 0.05, dm = 0.10, d90 = 0.2, J = 0.03, Rs = 1, um = 2, B = 5)

}
\references{
Smart, G. M., & Jäggi, M. N. R. (1983). Sediment transport in steilen
Gerinnen. Mitteilungen der Versuchsanstalt für Wasserbau, Hydrologie und
Glaziologie der ETH Zürich, 64, Zürich.
}
