% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_layout.R
\name{label_layout}
\alias{label_layout}
\title{Label layout}
\usage{
label_layout(
  data = NA,
  size,
  border_width = NA,
  border_color = "black",
  background = NA,
  units = "cm"
)
}
\arguments{
\item{data}{data frame to build the labels}

\item{size}{label size (numeric: c(10, 2.5))}

\item{border_width}{border width (numeric: 0.5)}

\item{border_color}{border color (string: "transparent")}

\item{background}{background color (string: "transparent")}

\item{units}{units for the label options (string: "cm")}
}
\value{
data frame
}
\description{
Generate labels options
}
\examples{

library(huito)

label <- label_layout(size = c(10, 2.5)
                   , border_color = "red"
                   , border_width = 1
                   ) 
                   
label \%>\% label_print()

}
