% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_check.R
\name{pp_check.hmcdm}
\alias{pp_check.hmcdm}
\title{Graphical posterior predictive checks for hidden Markov cognitive diagnosis model}
\usage{
\method{pp_check}{hmcdm}(object, plotfun = "dens_overlay", type = "total_score", ...)
}
\arguments{
\item{object}{a fitted model object of class "\code{hmcdm}".}

\item{plotfun}{A character string naming the type of plot. The list of available
plot functions include \code{"dens_overlay"}, \code{"hist"}, \code{"stat_2d"}, \code{"scatter_avg"}, \code{"error_scatter_avg"}.
The default function is \code{"dens_overlay"}.}

\item{type}{A character string naming the statistic to be used for obtaining posterior predictive distribution plot.
The list of available types include \code{"total_score"}, \code{"item_mean"}, \code{"item_OR"}, \code{"latency_mean"}, and \code{"latency_total"}. The default type is \code{"total_score"} which examines total scores of subjects.
Type \code{"item_mean"} is related to the first order moment and examines mean scores of all the items included in the test.
Type \code{"item_OR"} is related to the second order moment and examines odds ratios of all item pairs.
Types \code{"latency_mean"} and \code{"total_latency"} are available only for \code{hmcdm} objects that include item response time information (i.e., \code{hmcdm} object fitted with "\code{DINA_HO_RT}" model).}

\item{...}{Additional arguments}
}
\value{
Plots for checking the posterior predictive distributions. The default \code{Plotfun} \code{"dens_overlay"} plots density of each dataset are overlaid with the distribution of the observed values.
}
\description{
\code{pp_check} method for class \code{hmcdm}.
}
\examples{
\donttest{
output_FOHM = hmcdm(Y_real_array,Q_matrix,"DINA_FOHM",Design_array,1000,500)
library(bayesplot)
pp_check(output_FOHM)
pp_check(output_FOHM, plotfun="hist", type="item_mean")
}
}
\references{
Zhang, S., Douglas, J. A., Wang, S. & Culpepper, S. A. (2019) <\doi{10.1007/978-3-030-05584-4_24}>
}
\seealso{
\code{\link[bayesplot:PPC-distributions]{bayesplot::ppc_dens_overlay()}}
\code{\link[bayesplot:PPC-test-statistics]{bayesplot::ppc_stat()}}
\code{\link[bayesplot:PPC-test-statistics]{bayesplot::ppc_stat_2d()}}
\code{\link[bayesplot:PPC-scatterplots]{bayesplot::ppc_scatter_avg()}}
\code{\link[bayesplot:PPC-errors]{bayesplot::ppc_error_scatter_avg()}}
}
