% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_cell_to_icosa_tri}
\alias{hexify_cell_to_icosa_tri}
\title{Convert Cell ID to Icosa Triangle coordinates}
\usage{
hexify_cell_to_icosa_tri(cell_id, resolution, aperture = 3L)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs (1-based)}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
Data frame with columns:
\item{icosa_triangle_face}{Triangle face number (0-19)}
\item{icosa_triangle_x}{X coordinate on triangle face}
\item{icosa_triangle_y}{Y coordinate on triangle face}
}
\description{
Converts DGGRID-compatible cell IDs to icosahedral triangle
coordinates (face, x, y). These are the coordinates produced by the
'Snyder' 'ISEA' forward projection.
}
\details{
Compatible with 'dggridR' dgSEQNUM_to_PROJTRI().
}
\examples{
# Get triangle coordinates for a cell
result <- hexify_cell_to_icosa_tri(cell_id = 1000, resolution = 10, aperture = 3)
print(result)

# Convert back to lon/lat using inverse projection
coords <- hexify_inverse(result$icosa_triangle_face,
                         result$icosa_triangle_x,
                         result$icosa_triangle_y)
}
\seealso{
\code{\link{hexify_cell_to_quad_ij}} for conversion to Quad IJ,
\code{\link{hexify_cell_to_lonlat}} for conversion to lon/lat

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
