% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.R
\name{gen-element}
\alias{gen-element}
\alias{gen.element}
\alias{gen.int}
\alias{gen.choice}
\alias{gen.subsequence}
\alias{gen.sample}
\alias{gen.sample.int}
\title{Random Sample Generation}
\usage{
gen.element(x, prob = NULL)

gen.int(n, prob = NULL)

gen.choice(..., prob = NULL)

gen.subsequence(x)

gen.sample(x, size, replace = FALSE, prob = NULL)

gen.sample.int(n, size, replace = FALSE, prob = NULL)
}
\arguments{
\item{x}{a list or vector to sample an element from.}

\item{prob}{a vector of probability weights for
obtaining the elements of the vector being
sampled.}

\item{n}{the number which is the maximum integer
sampled from.}

\item{...}{generators to sample from}

\item{size}{a non-negative integer or a generator of
one, giving the number of items to choose.}

\item{replace}{Should sampling be with replacement?}
}
\value{
\code{gen.element} returns an item from the list
  or vector; \code{gen.int}, an integer up to the value
  n; \code{gen.choice}, a value from one of given selected
  generators; \code{gen.subsequence} an ordered subsequence
  from the input sequence; and \code{gen.sample} a list or
  vector (depending on the input) of the inputs.

  For \code{gen.element} and \code{gen.choice}, shrinking
  will move towards the first item; \code{gen.int} will
  shrink to 1; \code{gen.subsequence} will shrink the list
  towards being empty; and \code{gen.sample} will shrink
  towards the original list order.
}
\description{
Generators which sample from a list or produce random
integer samples. Both single sample, with \code{gen.element};
and multi-sample, with \code{gen.sample} and \code{gen.subsequence}
are supported; while \code{gen.choice} is used to choose from
generators instead of examples.
}
\details{
These generators implement shrinking.
}
\examples{
gen.element(1:10)   # a number
gen.element(c(TRUE,FALSE)) # a boolean
gen.int(10) # a number up to 10
gen.choice(gen.element(1:10), gen.element(letters))
gen.choice(NaN, Inf, gen.unif(-10, 10), prob = c(1,1,10))
gen.subsequence(1:10)

}
