\name{corrExp}
\alias{corrExp}
\title{Exponential correlation matrix}
\usage{corrExp(rho=0, tfu)}
\description{Constructs an exponential correlation matrix.}
\arguments{
 \item{rho}{Correlation parameter.}
 \item{tfu}{Follow-up time points, in standardized format from function
 \code{\link{tfuStandard}}.}
}
\value{
 Returns an \code{s} x \code{s} correlation matrix. Where \code{s} is the number
 of occasions (follow-up time points) at which the study outcome is observed.
}
\examples{

 # Exponential correlation model for outcomes at 3, 6, 12 and 24 months
 # Based on correlation 0.5 between outcomes separated by 3 month
 corrExp(0.5, tfuStandard(c(3,6,12,24), tref=c(1,2)))

 # Based on correlation 0.25 between outcomes separated by 1 year
 corrExp(0.25, tfuStandard(c(3,6,12,24), tref=c(3,4)))

}
