% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allCross.R
\name{allCrosses}
\alias{allCrosses}
\title{Generate all crosses from given parent set.}
\usage{
allCrosses(n, line_id)
}
\arguments{
\item{n}{Number of parents}

\item{line_id}{Character vector of parent names}
}
\value{
List of crossing procedure.
The output value is defined by "multiPhylo" class.
}
\description{
Generate all crosses from given parent set.
}
\note{
This function is adapted and modified from `allTrees`, `dfactorial`, and `ldfactorial` functions in the R package `phangorn` (GPL-2 | GPL-3).
See: https://cran.r-project.org/web/packages/phangorn/index.html
}
\examples{
n <- 3
line_id <- c("x1", "x2", "x7")
rslt <- allCrosses(n, line_id)
plot(rslt[[1]])
plot(rslt[[2]])
plot(rslt[[3]])

}
\references{
K.P. Schliep (2011) phangorn: phylogenetic analysis in R
}
