% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_index.R
\name{preference_index}
\alias{preference_index}
\title{Preference index from rankings}
\usage{
preference_index(object)
}
\arguments{
\item{object}{A \code{rankings} object (from \pkg{PlackettLuce}) or
a matrix that can be coerced to rankings with
\code{\link[PlackettLuce]{as.rankings}}.}
}
\value{
A \code{gosset_df} (data.frame subclass) with columns:
\describe{
  \item{item}{Item identifier (name).}
  \item{n}{Number of appearances of the item across sets.}
  \item{top}{Expected top probability (\%).}
  \item{bottom}{Expected bottom probability (\%).}
  \item{net_winning}{Net winning probability (\%).}
  \item{worth}{Normalized worth parameter.}
}
}
\description{
Computes a preference index for each item in a ranking 
using Plackett–Luce worth parameters. For each item, the function
estimates the probability of being ranked at the top or bottom
of the sets in which it appears, and calculates a net winning
probability as the difference between top and bottom probabilities.
}
\details{
The preference index provides a model-based summary of performance
across all ranking sets. Probabilities are derived from the fitted
Plackett–Luce worth parameters, normalized to sum to one.

For each item:
\itemize{
  \item \code{top_probs} is the expected probability (in percent)
  of being ranked first in its sets.
  \item \code{bottom_probs} is the expected probability (in percent)
  of being ranked last in its sets.
  \item \code{net_winning_probs} is the difference
  \code{top_probs - bottom_probs}, a relative preference score.
  \item \code{worth} is the normalized worth parameter from the
  Plackett–Luce model.
}

The output is ordered by descending net winning probability,
providing a leaderboard-style summary of items.
}
\examples{
library(PlackettLuce)

R = matrix(c(1, 2, 0, 0,
             4, 1, 2, 3,
             2, 1, 3, 0,
             1, 2, 3, 0,
             2, 1, 3, 0,
             1, 0, 3, 2),
           nrow = 6, byrow = TRUE)
colnames(R) = c("apple", "banana", "orange", "pear")
R = as.rankings(R)

preference_index(R)

}
\seealso{
\code{\link[PlackettLuce]{PlackettLuce}},
\code{\link[PlackettLuce]{as.rankings}},
\code{\link[gosset]{worth_map}}
}
