% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_lux_file.R
\name{read_lux_file}
\alias{read_lux_file}
\title{Read Light Data from .lux Files}
\usage{
read_lux_file(file_path)
}
\arguments{
\item{file_path}{Character string specifying the path to the .lux file}
}
\value{
A data.frame with columns:
  \item{Date}{POSIXct datetime in UTC}
  \item{Light}{Numeric light intensity in lux}
}
\description{
Reads and parses light intensity data from .lux files generated by
geolocation loggers. Handles various formats and automatically detects
the start of data.
}
\examples{
# Read example data included with package
example_file <- gls_example("W086")
light_data <- read_lux_file(example_file)
head(light_data)

}
